unit FStarF;
//*******************************************************
// Example program demonstrating trees stored in forward
// star format.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus,
  FStarC, StdCtrls;

type
  TFStarForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    CmdAdd: TButton;
    CmdRemove: TButton;
    mnuShowArrays: TMenuItem;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure SetButtons;
    procedure SelectNode(X, Y : Integer);
    procedure CmdAddClick(Sender: TObject);
    procedure CmdRemoveClick(Sender: TObject);
    procedure mnuShowArraysClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FStarForm: TFStarForm;

implementation

var
    tree            : TFStarTree;
    x0, y0, node_id : Integer;

{$R *.DFM}

procedure TFStarForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TFStarForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin


    MessageDlg(
        'Niniejszy program ilustruje manipulowanie wzami drzewa dowolnego stopnia' + CR +
        'zrealizowanego w reprezentacji forward star.' + CRCR +
        'Kliknij w dowolny wze, a nastpnie w przycisk "Dodaj potomka"' + CR +
        ' - spowoduje to dodanie wza potomnego do wyrnionego wza.' + CRCR +
        'Kliknicie w przycisk "Usu wze" spowoduje usunicie wyrnionego wza.'
        , mtInformation, [mbOK], 0);

end;

procedure TFStarForm.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    // Select the node at the given point.
    SelectNode(X, Y);
end;

// Create the root node.
procedure TFStarForm.FormCreate(Sender: TObject);
var
    xmin : Integer;
begin
    // Create a one node tree.
    tree := TFStarTree.Create;
    node_id := 0;

    // Save the coordinates where we will start drawing.
    x0 := 3;
    y0 := CmdAdd.Top + CmdAdd.Height + 3;

    // Use bold text.
    Canvas.Font.Style := [fsBold];

    // Position the initial one node tree.
    xmin := x0;
    tree.SetPosition(1, xmin, y0);
end;

// Draw the tree.
procedure TFStarForm.FormPaint(Sender: TObject);
var
    rect : TRect;
begin
    // Erase the canvas.
    rect.Left := 0;
    rect.Right := Width;
    rect.Top := 0;
    rect.Bottom := Height;
    Canvas.Brush.Color := clLtGray;
    Canvas.FillRect(rect);

    // Draw the tree.
    tree.DrawSubtree(Canvas, 1);
end;

// Enable the correct buttons for the selected node.
procedure TFStarForm.SetButtons;
begin
    if (tree.Selected < 1) then
    begin
        CmdAdd.Enabled    := False;
        CmdRemove.Enabled := False;
    end else begin
        CmdAdd.Enabled    := True;
        CmdRemove.Enabled := (
            (not tree.SelectedHasChildren) and
            (tree.Selected > 1));
    end;
end;

procedure TFStarForm.SelectNode(X, Y : Integer);
begin
    // Make the tree select the node.
    tree.SelectNode(X, Y, 1);
    Refresh;
    SetButtons;
end;

// Add a left child to the selected node.
procedure TFStarForm.CmdAddClick(Sender: TObject);
var
    xmin, to_node : Integer;
begin
    node_id := node_id + 1;
    to_node := tree.MakeNode(IntToStr(node_id));
    tree.MakeLink(tree.Selected, to_node);

    // Reposition the nodes.
    xmin := x0;
    tree.SetPosition(1, xmin, y0);

    SetButtons;
    Refresh;
end;

// Remove the selected node and its descendants.
procedure TFStarForm.CmdRemoveClick(Sender: TObject);
var
    xmin : Integer;
begin
    // Remove the selected node from the tree.
    tree.RemoveSelected;

    // Reposition the remaining nodes.
    xmin := x0;
    tree.SetPosition(1, xmin, y0);

    SetButtons;
    Refresh;
end;

// Show the forward star arrays.
procedure TFStarForm.mnuShowArraysClick(Sender: TObject);
begin
    tree.ShowArrays;
end;

end.
