unit Facto1F;
//*******************************************************
// Example program demonstrating recursive factorials.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

type
  TFacto1Form = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    NEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    ResultLabel: TLabel;
    CmdCompute: TButton;
    procedure NEditChange(Sender: TObject);
    procedure NumbersOnly(Sender: TObject; var Key: Char);
    procedure CmdComputeClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Facto1Form: TFacto1Form;

    function Factorial(n : Double) : Double;

implementation

{$R *.DFM}

procedure TFacto1Form.NEditChange(Sender: TObject);
begin
    CmdCompute.Enabled := (NEdit.Text <> '');
end;

procedure TFacto1Form.NumbersOnly(Sender: TObject; var Key: Char);
begin
    if (Key = #8) then exit; // Backspace.
    if ((Key >= '0') and (Key <= '9')) then exit;
    Key := #0;
end;

procedure TFacto1Form.CmdComputeClick(Sender: TObject);
var
    n : Double;
begin
    n := StrToFloat(NEdit.Text);
    if (n > 170) then
        ShowMessage('N nie moe by wiksze ni 170.')
    else
        ResultLabel.Caption :=
            Format('%.6g', [Factorial(n)]);
end;

procedure TFacto1Form.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TFacto1Form.mnuAboutClick(Sender: TObject);
const
    CR = #13#10;
    CRCR = #13#10#13#10;
begin

    MessageDlg(
        'Niniejszy program oblicza funkcj "silnia" korzystajc z jej rekurencyjnej definicji:' + CRCR +
        '    0! = 1' + CR +
        '    N! = N * (N - 1)!        dla N > 0' + CRCR +
        'Wprowad argument i kliknij w przycisk "Oblicz".'
        , mtInformation, [mbOK], 0);




end;

// Compute factorials recursively.
function Factorial(n : Double) : Double;
begin
    if (n <= 1) then
        Factorial := 1
    else
        Factorial := n * Factorial(n - 1);
end;

end.
