unit VSparseF;
//*******************************************************
// Example program demonstrating very sparse arrays.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  VSparseC, ExtCtrls;

type
  TVerySparseForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    RowEdit: TEdit;
    Label3: TLabel;
    ValueEdit: TEdit;
    CmdSet: TButton;
    ColEdit: TEdit;
    procedure mnuAboutClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure EnableButtons(Sender: TObject);
    procedure CmdSetClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VerySparseForm: TVerySparseForm;

implementation

var
    the_array : TVerySparseArray;

{$R *.DFM}

procedure TVerySparseForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;

begin


    MessageDlg(
        'Niniejszy program ilustruje zarzdzanie bardzo rzadk macierz.' + CRCR +
        'Wprowad wiersz, kolumn i warto przypisywan elementowi.' + CR +
        'Jeeli dana pozycja nie istnieje w strukturze implementujcej tablic,' + CR +
        'zostanie automatycznie utworzona.' + CRCR +
        'Podanie wartoci pustej spowoduje natomiast usunicie wskazanego elementu ze struktury.'
        , mtInformation, [mbOK], 0);


end;

procedure TVerySparseForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

// Draw the items in the array.
procedure TVerySparseForm.FormPaint(Sender: TObject);
begin
    the_array.DrawArray(Canvas,
        Abs(Canvas.Font.Height) + 6, 2,
        ValueEdit.Left + ValueEdit.Width + 5);
end;

procedure TVerySparseForm.EnableButtons(Sender: TObject);
begin
    CmdSet.Enabled :=
        ((RowEdit.Text <> '') and (ColEdit.Text <> ''));
end;

procedure TVerySparseForm.CmdSetClick(Sender: TObject);
begin
    the_array.SetValue(
        StrToInt(RowEdit.Text), StrToInt(ColEdit.Text),
        ValueEdit.Text);
    RowEdit.Text := '';
    ColEdit.Text := '';
    ValueEdit.Text := '';
    RowEdit.SetFocus;
    Refresh;
end;

procedure TVerySparseForm.FormCreate(Sender: TObject);
begin
    the_array := TVerySparseArray.Create;

    // Create the_array(0, 0) so the picture looks ok.
    the_array.SetValue(0, 0, 'x');
    the_array.SetValue(0, 0, '');
end;

procedure TVerySparseForm.EditKeyPress(Sender: TObject; var Key: Char);
begin
    if (Key = #8) then exit; // Backspace.
    if ((Key >= '0') and (Key <= '9')) then exit;
    Key := #0;
end;


end.
