unit CircleQF;
//*******************************************************
// Example program demonstrating circular queues.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  CircleQC, ExtCtrls;

type
  TCircleQForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    ListLabel: TLabel;
    ItemText: TEdit;
    CmdEnterQueue: TButton;
    CmdLeaveQueue: TButton;
    QueueImage: TImage;
    procedure mnuAboutClick(Sender: TObject);
    procedure CmdEnterQueueClick(Sender: TObject);
    procedure CmdLeaveQueueClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CircleQForm: TCircleQForm;

implementation

var
    the_queue : TCircleQueue;

{$R *.DFM}

procedure TCircleQForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin
    MessageDlg(
        'Ten program demonstruje funkcjonowanie kolejki cyklicznej.' + CRCR +
        'Wpisz dowolny acuch i kliknij przycisk "Wprowad do kolejki", w wyniku czego' + CR +
        'acuch ten zostanie umieszczony w kolejce. ' + CRCR +
        'Kliknij przycisk "Pobierz z kolejki" aby usun z kolejki element czoowy.',
         mtInformation, [mbOK], 0);

end;

procedure TCircleQForm.CmdEnterQueueClick(Sender: TObject);
begin
    the_queue.EnterQueue(ItemText.Text);
    ListLabel.Caption := the_queue.TextValue;
    the_queue.DrawQueue(QueueImage);
    ItemText.Text := '';
    ItemText.SetFocus;
    CmdEnterQueue.Enabled := False;
    CmdLeaveQueue.Enabled := True;
end;

procedure TCircleQForm.CmdLeaveQueueClick(Sender: TObject);
begin
    ItemText.Text := the_queue.LeaveQueue;
    ItemText.SetFocus;
    ListLabel.Caption := the_queue.TextValue;
    the_queue.DrawQueue(QueueImage);
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
    CmdLeaveQueue.Enabled := (not the_queue.QueueEmpty);
end;

procedure TCircleQForm.ItemTextChange(Sender: TObject);
begin
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
end;

procedure TCircleQForm.FormCreate(Sender: TObject);
begin
    the_queue := TCircleQueue.Create;
end;

procedure TCircleQForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

end.
