unit BtreeF;
//*******************************************************
// Example program demonstrating B-trees.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  BtreeC, BtreeNC;

type
  TBtreeForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    CmdAdd: TButton;
    CmdRemove: TButton;
    Label1: TLabel;
    ValueText: TEdit;
    Label2: TLabel;
    NodesLabel: TLabel;
    TreeScrollBox: TScrollBox;
    TreeLabel: TLabel;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CmdAddClick(Sender: TObject);
    procedure CmdRemoveClick(Sender: TObject);
    procedure ValueTextChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BtreeForm: TBtreeForm;

implementation

var
    tree   : TBtree;
    x0, y0 : Integer;

{$R *.DFM}

procedure TBtreeForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TBtreeForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
begin
    MessageDlg(
        'This program allows you to manage an AVL tree.' + CRCR +
        'Enter a number and click Add to add an item to the tree. Click Remove to remove the item from the tree.'
        , mtInformation, [mbOK], 0);
end;

// Create the root node.
procedure TBtreeForm.FormCreate(Sender: TObject);
begin
    // Create an empty tree.
    tree := TBtree.Create;

    // Save the coordinates where we will start drawing.
    x0 := 3;
    y0 := CmdAdd.Top + CmdAdd.Height + 3;

    // Use bold text.
    Canvas.Font.Style := [fsBold];
end;

// Add a value to the tree.
procedure TBtreeForm.CmdAddClick(Sender: TObject);
begin
    tree.Add(StrToInt(ValueText.Text));
    NodesLabel.Caption := IntToStr(TBtreeNode.NumAllocated);

    // Redisplay the tree.
    TreeLabel.Caption := tree.TextValue;

    ValueText.Text := '';
    ValueText.SetFocus;
end;

// Remove the indicated value from the tree.
procedure TBtreeForm.CmdRemoveClick(Sender: TObject);
begin
    // Remove the selected node from the tree.
    tree.Remove(StrToInt(ValueText.Text));
    NodesLabel.Caption := IntToStr(TBtreeNode.NumAllocated);

    // Display the tree.
    TreeLabel.Caption := tree.TextValue;

    ValueText.Text := '';
    ValueText.SetFocus;
end;

procedure TBtreeForm.ValueTextChange(Sender: TObject);
begin
    CmdAdd.Enabled := (ValueText.Text <> '');
    CmdRemove.Enabled := (CmdAdd.Enabled and tree.NotEmpty);
end;

// Destroy the tree and verify that all nodes have been
// destroyed.
procedure TBtreeForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    tree.Free;
    if (TBtreeNode.NumAllocated <> 0) then
        ShowMessage(Format(
            'Warning: %d nodes are still allocated.',
            [TBtreeNode.NumAllocated]));
end;

// Make TreeScrollBox as large as possible.
procedure TBtreeForm.FormResize(Sender: TObject);
var
    wid, hgt : Integer;
begin
    wid := ClientWidth - TreeScrollBox.Left;
    if (wid < 10) then wid := 10;
    hgt := ClientHeight - TreeScrollBox.Top;
    if (top < 10) then top := 10;
    TreeScrollBox.Width := wid;
    TreeScrollBox.Height := hgt;
end;

end.
