unit SerRect;
//*******************************************************
// Serializable command object that draws a rectangle.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses SerDraw, Graphics;

type
    TRectangleCmd = class(TDrawingCommand)
        public
            procedure Draw(cvs : TCanvas; permanent : Boolean); override;
            function Serialization : String; override;
    end;

implementation

// Draw a rectangle.
procedure TRectangleCmd.Draw(cvs : TCanvas; permanent : Boolean);
begin
    if (permanent) then
    begin
        cvs.Pen.Color := color;
        cvs.Brush.Color := color;
        cvs.Brush.Style := style;
    end;
    cvs.Rectangle(x1, y1, x2, y2);
end;

// Return the object's serialization. TDrawingCommand does
// most of the work.
function TRectangleCmd.Serialization : String;
const
    CR = #13#10;
begin
    Result := 'TRectangleCmd(' + CR +
        inherited Serialization + ')';
end;

end.
