unit SparseF;
//*******************************************************
// Example program demonstrating sparse arrays.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  SparseC, ExtCtrls;

type
  TSparseForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    RowEdit: TEdit;
    ColEdit: TEdit;
    Label3: TLabel;
    ValueEdit: TEdit;
    CmdSet: TButton;
    procedure mnuAboutClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure EnableButtons(Sender: TObject);
    procedure CmdSetClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SparseForm: TSparseForm;

implementation

var
    the_array : TSparseArray;

{$R *.DFM}

procedure TSparseForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin



    MessageDlg(
        'Niniejszy program ilustruje zarzdzanie macierz rzadk.' + CRCR +
        'Wprowad wiersz, kolumn i warto przypisywan elementowi.' + CR +
        'Jeeli dana pozycja nie istnieje w strukturze implementujcej tablic,' + CR +
        'zostanie automatycznie utworzona.' + CRCR +
        'Podanie wartoci pustej spowoduje natomiast usunicie wskazanego elementu ze struktury.'
        , mtInformation, [mbOK], 0);


end;

procedure TSparseForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

// Draw the items in the array.
procedure TSparseForm.FormPaint(Sender: TObject);
var
    r, c, max_row, max_col : Longint;
    l, t, w, h  : Integer;
    x, y        : Integer;
    value       : String;
    text_size   : TSize;
    rect        : TRect;

begin
    h := Round(Label2.Height * 1.3);
    w := Round(Label2.Width  * 1.3);
    t := 4;
    l := ValueEdit.Left + ValueEdit.Width + 10;

    // Draw a grid.
    max_row := the_array.MaxRow;
    max_col := the_array.MaxCol;
    rect.Left   := l;
    rect.Top    := t;
    rect.Bottom := t + (max_row + 2) * h;
    rect.Right  := l + (max_col + 2) * w;

    Canvas.Brush.Color := clWhite;
    Canvas.FillRect(rect);
    for r := 0 to max_row + 2 do
    begin
        Canvas.MoveTo(l, t + r * h);
        Canvas.LineTo(l + (max_col + 2) * w, t + r * h);
    end;
    for c := 0 to max_col + 2 do
    begin
        Canvas.MoveTo(l + c * w, t);
        Canvas.LineTo(l + c * w, t + (max_row + 2) * h);
    end;

    // Draw the column labels.

    Canvas.Font.Style := [fsBold];
    Canvas.Font.Color := clBlue;
    for c := 0 to max_col do
    begin
        value := IntToStr(c);
        text_size := Canvas.TextExtent(value);
        x := l + Round((c + 1.5) * w - text_size.cx / 2);
        y := t + Round(0.5 * h - text_size.cy / 2);
        Canvas.TextOut(x, y, value);
    end;

    // Draw the row labels.
    for r := 0 to max_row do
    begin
        value := IntToStr(r);
        text_size := Canvas.TextExtent(value);
        x := l + Round(0.5 * w - text_size.cx / 2);
        y := t + Round((r + 1.5) * h - text_size.cy / 2);
        Canvas.TextOut(x, y, value);
    end;

    // Draw the array entries.
    for r := 0 to max_row do
    begin
        for c := 0 to max_col do
        begin
            value := the_array.GetValue(r, c);
            text_size := Canvas.TextExtent(value);
            x := l + Round((c + 1.5) * w - text_size.cx / 2);
            y := t + Round((r + 1.5) * h - text_size.cy / 2);
            Canvas.TextOut(x, y, value);
        end;
    end;
end;

procedure TSparseForm.EnableButtons(Sender: TObject);
begin
    CmdSet.Enabled :=
        ((RowEdit.Text <> '') and (ColEdit.Text <> ''));
end;

procedure TSparseForm.CmdSetClick(Sender: TObject);
begin
    the_array.SetValue(
        StrToInt(RowEdit.Text), StrToInt(ColEdit.Text),
        ValueEdit.Text);
    RowEdit.Text := '';
    ColEdit.Text := '';
    ValueEdit.Text := '';
    RowEdit.SetFocus;
    Refresh;
end;

procedure TSparseForm.FormCreate(Sender: TObject);
begin
    the_array := TSparseArray.Create;

    // Create the_array(0, 0) so the picture looks ok.
    the_array.SetValue(0, 0, 'x');
    the_array.SetValue(0, 0, '');
end;

procedure TSparseForm.EditKeyPress(Sender: TObject; var Key: Char);
begin
    if (Key = #8) then exit; // Backspace.
    if ((Key >= '0') and (Key <= '9')) then exit;
    Key := #0;
end;

end.
