unit ArrayQF;
//*******************************************************
// Example program demonstrating array-based queues.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ArrayQC, Menus, StdCtrls;

type
  TArrayQForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    ItemText: TEdit;
    CmdEnterQueue: TButton;
    CmdLeaveQueue: TButton;
    ListLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure CmdEnterQueueClick(Sender: TObject);
    procedure CmdLeaveQueueClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ArrayQForm: TArrayQForm;

implementation

var
    the_queue : TArrayQueue;

{$R *.DFM}

procedure TArrayQForm.FormCreate(Sender: TObject);
begin
    // Create the TArrayQueue object.
    the_queue := TArrayQueue.Create;
end;

procedure TArrayQForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin
    MessageDlg(
        'Ten program demonstruje funkcjonowanie kolejki w postaci tablicy.' + CRCR +
        'Wpisz dowolny acuch i kliknij przycisk "Wprowad do kolejki", w wyniku czego' + CR +
        'acuch ten zostanie umieszczony w kolejce. ' + CRCR +
        'Kliknij przycisk "Pobierz z kolejki" aby usun z kolejki element czoowy.',
         mtInformation, [mbOK], 0);

end;

procedure TArrayQForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TArrayQForm.CmdEnterQueueClick(Sender: TObject);
begin
    the_queue.EnterQueue(ItemText.Text);
    ListLabel.Caption := the_queue.TextValue;
    ItemText.Text := '';
    ItemText.SetFocus;
    CmdEnterQueue.Enabled := False;
    CmdLeaveQueue.Enabled := True;
end;

procedure TArrayQForm.CmdLeaveQueueClick(Sender: TObject);
begin
    ItemText.Text := the_queue.LeaveQueue;
    ItemText.SetFocus;
    ListLabel.Caption := the_queue.TextValue;
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
    CmdLeaveQueue.Enabled := (not the_queue.QueueEmpty);
end;

procedure TArrayQForm.ItemTextChange(Sender: TObject);
begin
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
end;

end.
