unit ArrayQF;
//*******************************************************
// Example program demonstrating array-based queues.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ArrayQC, Menus, StdCtrls;

type
  TArrayQForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    ItemText: TEdit;
    CmdEnterQueue: TButton;
    CmdLeaveQueue: TButton;
    ListLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure CmdEnterQueueClick(Sender: TObject);
    procedure CmdLeaveQueueClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ArrayQForm: TArrayQForm;

implementation

var
    the_queue : TArrayQueue;

{$R *.DFM}

procedure TArrayQForm.FormCreate(Sender: TObject);
begin
    // Create the TArrayQueue object.
    the_queue := TArrayQueue.Create;
end;

procedure TArrayQForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
begin
    MessageDlg(
        'This program demonstrates an array-based queue class.' + CRCR +
        'Enter a string and click the Enter button to add a new item to the queue. ' +
        'Click the Leave button to remove the top item from the queue.' + CRCR +
        'The array is resized when the top of the list passes the value ResizeWhen.' + CRCR +
        'Keep in mind that each time the queue is resized the items are moved into a new array. ' +
        'Also note that the queue requires resizing as items are added and removed even if the total number of items does not change much.'
        , mtInformation, [mbOK], 0);
end;

procedure TArrayQForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TArrayQForm.CmdEnterQueueClick(Sender: TObject);
begin
    the_queue.EnterQueue(ItemText.Text);
    ListLabel.Caption := the_queue.TextValue;
    ItemText.Text := '';
    ItemText.SetFocus;
    CmdEnterQueue.Enabled := False;
    CmdLeaveQueue.Enabled := True;
end;

procedure TArrayQForm.CmdLeaveQueueClick(Sender: TObject);
begin
    ItemText.Text := the_queue.LeaveQueue;
    ItemText.SetFocus;
    ListLabel.Caption := the_queue.TextValue;
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
    CmdLeaveQueue.Enabled := (not the_queue.QueueEmpty);
end;

procedure TArrayQForm.ItemTextChange(Sender: TObject);
begin
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
end;

end.
