unit Cmd2Ell;
//*******************************************************
// A command class that draws an ellipse.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses Cmd2Draw, Graphics;

type
    TEllipseCmd = class(TDrawingCommand)
        public
            procedure Draw(cvs : TCanvas; permanent : Boolean); override;
    end;

implementation

// Draw an ellipse.
procedure TEllipseCmd.Draw(cvs : TCanvas; permanent : Boolean);
begin
    if (permanent) then
    begin
        cvs.Pen.Color := color;
        cvs.Brush.Color := color;
        cvs.Brush.Style := style;
    end;
    cvs.Ellipse(x1, y1, x2, y2);
end;

end.
