unit Serials;
//*******************************************************
// Serialization helper routines.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses SysUtils;

    procedure GetToken(var txt, token_name, token_value : String);

implementation

// Return the first token name/value pair from txt. Return
// txt with the token and value removed. Return
// token_name = '' when there are no more tokens.
//
// Token strings are of the form:
//    name(value)name(value)...
procedure GetToken(var txt, token_name, token_value : String);
var
    i, open_pos, num_open, txt_len : Integer;
    ch                             : Char;
begin
    token_name := '';
    token_value := '';

    // Find the first open parenthesis.
    open_pos := Pos('(', txt);
    if (open_pos = 0) then exit;

    // Find the corresponding close parenthesis.
    num_open := 1;
    txt_len := Length(txt);
    for i := open_pos + 1 to txt_len do
    begin
        ch := txt[i];
        case ch of
            '(': num_open := num_open + 1;
            ')': begin
                     num_open := num_open - 1;
                     if (num_open = 0) then break;
                 end;
        end;
    end;

    // Save the token name and value.
    token_name := Trim(Copy(txt, 1, open_pos - 1));
    token_value := Trim(Copy(txt, open_pos + 1, i - open_pos - 1));

    if (i > txt_len) then
        txt := ''
    else
        txt := Copy(txt, i + 1, txt_len - i);
end;

end.
