unit MvcTabV;
//*******************************************************
// Table view/controller class for example program
// demonstrating the Model/View/Controller (MVC)
// paradigm.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
    MvcModel, MvcTabF;
    
type
    TMvcTableView = class(TMvcView)
        private
            TheTableForm : TTableForm;
        public
            constructor Create(model : TMvcModel; frm : TTableForm);
            procedure DataModified; override;
    end;

implementation

// Save a reference to the form.
constructor TMvcTableView.Create(model : TMvcModel; frm : TTableForm);
begin
    // We save the form first because Create in the
    // TMvcView base class calls DataModified.
    TheTableForm := frm;
    frm.TheModel := model;
    frm.TheView := Self;

    inherited Create(model);
end;

// Update the view display.
procedure TMvcTableView.DataModified;
begin
    TheTableForm.ShowData;
end;

end.
