unit BPlusSF;
//*******************************************************
// Dialog for displaying B+tree structure.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TStructForm = class(TForm)
    StructScrollBox: TScrollBox;
    CmdOk: TButton;
    StructLabel: TLabel;
    procedure FormResize(Sender: TObject);
    procedure CmdOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  StructForm: TStructForm;

implementation

{$R *.DFM}

// Make the ScrollBox as large as possible.
procedure TStructForm.FormResize(Sender: TObject);
begin
    CmdOk.Left := (ClientWidth - CmdOk.Width) div 2;
    CmdOk.Top := ClientHeight - CmdOk.Height - 8;
    StructScrollBox.Width := ClientWidth;
    StructScrollBox.Height := CmdOk.Top - 8;
end;

// Unload the form.
procedure TStructForm.CmdOkClick(Sender: TObject);
begin
    Close;
end;

end.
