unit AVLF;
//*******************************************************
// Example program demonstrating AVL trees.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  AVLTC, AVLNC;

type
  TAVLForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mnuExit: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    CmdAdd: TButton;
    CmdRemove: TButton;
    Label1: TLabel;
    ValueText: TEdit;
    Label2: TLabel;
    NodesLabel: TLabel;
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure CmdAddClick(Sender: TObject);
    procedure CmdRemoveClick(Sender: TObject);
    procedure ValueTextChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AVLForm: TAVLForm;

implementation

var
    tree   : TAVLTree;
    x0, y0 : Integer;

{$R *.DFM}

procedure TAVLForm.mnuExitClick(Sender: TObject);
begin
    Close;
end;

procedure TAVLForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin

    MessageDlg(
        'Niniejszy program ilustruje funkcjonowanie drzewa AVL.' + CRCR +
        'Wprowad warto i kliknij przycisk "Wstaw", aby umieci w drzewie wze' + CR +
        'zawierajcy t warto.' + CRCR +
        'Kliknij przycisk "Usu", aby usun wze zawierajcy podan warto.'
        , mtInformation, [mbOK], 0);

end;

// Create the root node.
procedure TAVLForm.FormCreate(Sender: TObject);
begin
    // Create an empty tree.
    tree := TAVLTree.Create;

    // Save the coordinates where we will start drawing.
    x0 := 3;
    y0 := CmdAdd.Top + CmdAdd.Height + 3;

    // Use bold text.
    Canvas.Font.Style := [fsBold];
end;

// Draw the tree.
procedure TAVLForm.FormPaint(Sender: TObject);
var
    rect : TRect;
begin
    // Erase the canvas.
    rect.Left := 0;
    rect.Right := Width;
    rect.Top := 0;
    rect.Bottom := Height;
    Canvas.Brush.Color := clLtGray;
    Canvas.FillRect(rect);

    // Draw the tree.
    tree.DrawTree(Canvas);
end;

// Add a value to the tree.
procedure TAVLForm.CmdAddClick(Sender: TObject);
begin
    tree.Add(StrToInt(ValueText.Text));
    NodesLabel.Caption := IntToStr(TAVLNode.NumAllocated);

    // Reposition the nodes.
    tree.SetPositions(x0, y0);
    Refresh;

    ValueText.Text := '';
    ValueText.SetFocus;
end;

// Remove the indicated value from the tree.
procedure TAVLForm.CmdRemoveClick(Sender: TObject);
begin
    // Remove the selected node from the tree.
    tree.Remove(StrToInt(ValueText.Text));
    NodesLabel.Caption := IntToStr(TAVLNode.NumAllocated);

    // Reposition the remaining nodes.
    tree.SetPositions(x0, y0);
    Refresh;

    ValueText.Text := '';
    ValueText.SetFocus;
end;

procedure TAVLForm.ValueTextChange(Sender: TObject);
begin
    CmdAdd.Enabled := (ValueText.Text <> '');
    CmdRemove.Enabled := (CmdAdd.Enabled and tree.NotEmpty);
end;

// Destroy the tree and verify that all nodes have been
// destroyed.
procedure TAVLForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    tree.Free;
    if (TAVLNode.NumAllocated <> 0) then
        ShowMessage(Format(
            'Uwaga: istniej nie zwolnione wzy w liczbie %d .',
            [TAVLNode.NumAllocated]));
end;

end.
