unit INT64NWPF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

type
  TForm1 = class(TForm)
    edDzielna: TEdit;
    edDzielnik: TEdit;
    lbTitle: TLabel;
    lbResult: TLabel;
    MainMenu1: TMainMenu;
    Plik1: TMenuItem;
    Koniec1: TMenuItem;
    Pomoc1: TMenuItem;
    Oprogramie1: TMenuItem;
    lbX: TLabel;
    lbY: TLabel;
    btnCalc: TButton;
    procedure btnCalcClick(Sender: TObject);
    procedure Koniec1Click(Sender: TObject);
    procedure Oprogramie1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


Function NWP(X,Y: INT64):INT64;
//  A. Grayski
var
  R: INT64;
begin
  if (X < 0) or (Y < 0)
  then
    NWP := NWP(Abs(X), Abs(Y))
  else
  begin   // teraz na pewno X > 0 i Y > 0
    if X < Y
    then
      NWP := NWP(Y,X)
    else
    begin // teraz na pewno X > Y X > 0
      if Y = 0 then
      begin
        if X = 0
        then
          raise EInvalidOperation.Create('Nieokrelona warto NWP(0,0)')
        else
          NWP := X
      end
      else
      begin
        R := X mod Y;
        if R = 0
        then
          NWP := Y
        else
          NWP := NWP(Y,R)
      end;
    end;
  end;
end;



procedure TForm1.btnCalcClick(Sender: TObject);
var
  Dzielna, Dzielnik, Wynik : INT64;
  err: INteger;
begin
  Val(edDzielna.Text, Dzielna, Err);
  if err <> 0 then
  begin
    MessageDlg('Bdna posta pierwszego argumentu',
               mtError, [mbOK], 0);
    Exit;
  end;

  Val(edDzielnik.Text, Dzielnik, Err);
  if err <> 0 then
  begin
    MessageDlg('Bdna posta drugiego argumentu',
               mtError, [mbOK], 0);
    exit;
  end;

  Wynik := NWP(Dzielna, Dzielnik);

  lbResult.Caption := IntToStr(Wynik);

end;

procedure TForm1.Koniec1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Oprogramie1Click(Sender: TObject);
const
  CRCR = #13#10#13#10;
  CR = #13#10;

begin
  MessageDlg(
     'Niniejszy program oblicza warto najwikszego wsplnego podzielnika' + CR +
     'dwch liczb cakowitych, uywajc do reprezentowania liczb typu INT64.' + CRCR +
     'Wprowad argumenty do oblicze (mog nimi by dowolne liczby cakowite)' + CR +
     'i kliknij w przycisk "Oblicz"',
     mtInformation, [mbOK], 0);

end;

end.
