unit LinkedQF;
//*******************************************************
// Example program demonstrating linked list-based queues.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  LinkedQC, Classes;

type
  TLinkedQForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    ItemText: TEdit;
    Label1: TLabel;
    CmdEnterQueue: TButton;
    CmdLeaveQueue: TButton;
    QueueLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
    procedure CmdEnterQueueClick(Sender: TObject);
    procedure CmdLeaveQueueClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  LinkedQForm: TLinkedQForm;

implementation

var
    the_queue : TLinkedQueue;

{$R *.DFM}

procedure TLinkedQForm.FormCreate(Sender: TObject);
begin
    // Make the queue.
    the_queue := TLinkedQueue.Create;
end;

procedure TLinkedQForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

procedure TLinkedQForm.mnuAboutClick(Sender: TObject);
const
    CR = #13#10;
    CRCR = #13#10#13#10;
begin

    MessageDlg(
        'Ten program demonstruje funkcjonowanie kolejki w postacicy listy czonej.' + CRCR +
        'Wpisz dowolny acuch i kliknij przycisk "Wprowad do kolejki", w wyniku czego' + CR +
        'acuch ten zostanie umieszczony w kolejce. ' + CRCR +
        'Kliknij przycisk "Pobierz z kolejki" aby usun z kolejki element czoowy.',
         mtInformation, [mbOK], 0);

end;

procedure TLinkedQForm.ItemTextChange(Sender: TObject);
begin
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
end;

procedure TLinkedQForm.CmdEnterQueueClick(Sender: TObject);
begin
    the_queue.EnterQueue(ItemText.Text);
    QueueLabel.Caption := the_queue.TextValue;
    ItemText.Text := '';
    ItemText.SetFocus;
    CmdEnterQueue.Enabled := False;
    CmdLeaveQueue.Enabled := True;
end;

procedure TLinkedQForm.CmdLeaveQueueClick(Sender: TObject);
begin
    ItemText.Text := the_queue.LeaveQueue;
    ItemText.SetFocus;
    QueueLabel.Caption := the_queue.TextValue;
    CmdEnterQueue.Enabled := (ItemText.Text <> '');
    CmdLeaveQueue.Enabled := (not the_queue.QueueEmpty);
end;

end.
