unit AStackF;
//*******************************************************
// Example program demonstrating array-based stacks.
//*******************************************************
// Copyright (C) 1998 John Wiley & Sons, Inc.
// All rights reserved. See additional copyright
// information in Readme.txt.
//
// Revised (C) 1999 Andrzej Grayski, HELION Publ.
//*******************************************************

interface

uses
  Windows, Messages, SysUtils, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls,
  AStackC, Classes;

type
  TAStackForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    mnuExit: TMenuItem;
    mnuAbout: TMenuItem;
    ItemText: TEdit;
    Label1: TLabel;
    CmdPush1: TButton;
    CmdPop1: TButton;
    StackLabel1: TLabel;
    CmdPush2: TButton;
    CmdPop2: TButton;
    StackLabel2: TLabel;
    CmdPush3: TButton;
    CmdPop3: TButton;
    StackLabel3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure CmdPushClick(Sender: TObject);
    procedure CmdPopClick(Sender: TObject);
    procedure ItemTextChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AStackForm: TAStackForm;

implementation

var
    the_stacks   : array[1..3] of TArrayStack;
    stack_labels : array[1..3] of TLabel;
    push_buttons : array[1..3] of TButton;
    pop_buttons  : array[1..3] of TButton;

{$R *.DFM}

procedure TAStackForm.FormCreate(Sender: TObject);
var
    i : Integer;
begin
    // Utwrz stosy
    for i := 1 to 3 do
      the_stacks[i] := TArrayStack.Create;

    // zgrupuj w tablic wskaniki do przyciskw "Push"
    push_buttons[1] := CmdPush1;
    push_buttons[2] := CmdPush2;
    push_buttons[3] := CmdPush3;

    // zgrupuj w tablic wskaniki do przyciskw "Pop"
    pop_buttons[1] := CmdPop1;
    pop_buttons[2] := CmdPop2;
    pop_buttons[3] := CmdPop3;

    // zgrupuj w tablic wskaniki do etykiet
    stack_labels[1] := StackLabel1;
    stack_labels[2] := StackLabel2;
    stack_labels[3] := StackLabel3;
end;

procedure TAStackForm.mnuExitClick(Sender: TObject);
begin
     Close;
end;

procedure TAStackForm.mnuAboutClick(Sender: TObject);
const
    CRCR = #13#10#13#10;
    CR = #13#10;
begin

    MessageDlg(
        'Ten program wykorzystuje stos w postaci tablicy.' + CRCR +
        'Wprowad nowy acuch i kliknij w jeden z przycikw Push' + CR +
        'w celu umieszczenia go na odpowiednim stosie.' + CRCR +
        'Kliknij w jeden z przyciskw Pop w celu zdjcia elementu ze stosu.'
        , mtInformation, [mbOK], 0);


end;

// Umie nowy element na stosie
procedure TAStackForm.CmdPushClick(Sender: TObject);
var
    i : Integer;
begin
    for i := 1 to 3do
    begin
        if (push_buttons[i] = Sender) then
        begin
            the_stacks[i].Push(ItemText.Text);
            stack_labels[i].Caption :=
                the_stacks[i].TextValue;
            ItemText.Text := '';
            ItemText.SetFocus;
            pop_buttons[i].Enabled := True;
            exit;
        end;
    end;
end;

procedure TAStackForm.CmdPopClick(Sender: TObject);
var
    i : Integer;
begin
    for i := 1 to 3do
    begin
        if (pop_buttons[i] = Sender) then
        begin
            ItemText.Text := the_stacks[i].Pop;
            stack_labels[i].Caption :=
                the_stacks[i].TextValue;
            ItemText.SetFocus;
            pop_buttons[i].Enabled :=
                (not the_stacks[i].StackEmpty);
            exit;
        end;
    end;
end;

procedure TAStackForm.ItemTextChange(Sender: TObject);
var
    i : Integer;
begin
    for i := 1 to 3 do
    begin
        push_buttons[i].Enabled := (ItemText.Text <> '');
    end;
end;

end.
