<?php
// Otwiera sesję PHP.
session_start();
// Uruchamia skrypt odpowiedzialny za obługę błędów i klasę weryfikującą.
require_once ('error_handler.php');
require_once ('validate.class.php');
   
// Tworzy nowy obiekt validator.
$validator = new Validate();

// Odczytuje rodzaj weryfikacji (PHP lub AJAX).
$validationType = '';   
if (isset($_POST['validationType']))
{
   $validationType = $_POST['validationType'];
}

// Weryfikacja AJAX czy PHP.
if ($validationType == 'php')
{
   // Weryfikacja PHP jest wykonywana za pomocą metody ValidatePHP, zwracającej
   // adres strony, na którą należy skierować użytkownika (allok.php, jeśli wszystkie
   // dane zostały podane poprawnie, lub index.php, jeśli wystąpiły błędy).
   header("Location:" . $validator->ValidatePHP());   
}
else
{
   // Weryfikacja AJAX jest wykonywana za pomocą metody ValidateAJAX. Wyniki służą do 
   // utworzenia dokumentu XML, wysyłanego potem do klienta.
   $response = array("result" =>   
   $validator->ValidateAJAX($_POST['inputValue'], $_POST['fieldID']),
      "fieldid" => $_POST['fieldID'] );
    
   // Generuje odpowiedź.
   if(ob_get_length()) ob_clean();
   header('Content-Type: application/json');
   echo json_encode($response);
}
?>
