// Aliasy dla wybranych funkcji
var byClass = HTML_AJAX_Util.getElementsByClassName;
var byId = function(id) {
	return document.getElementById(id);
}
var d = function(item) {
	alert(HTML_AJAX_Util.quickPrint(item));
}

function setup() {
	for(var i = 0; i < app.setup.length; i++) {
		app.setup[i]();
	}
	selectSection('front');
}

function selectSection(name) {

	if (!app.isLoggedIn && 
		(name != 'front' && 
			name != 'ticket' && 
			name != 'register')
	) {
		name = 'front';
	}

	var s = byClass('section',byId('body'));
	for(var i = 0; i < s.length; i++) {
		if (s[i].id == name) {
			s[i].style.display = 'block';
			if (s[i].onDisplay) {
				s[i].onDisplay();
			}
		}
		else {
			s[i].style.display = 'none';
		}
	}
}

function setMessage(element,message) {
	element.innerHTML = message;
	element.className = 'message';
	
	element.style.display = 'block';

	window.setTimeout(function() { 
		new Effect.Fade(element); },3000);
}

// Funkcje narzdziowe
function positionOver(element) {
	var target = element.parentNode;
	target.style.position = 'relative';
	element.style.position = 'absolute';
	element.style.top = 0;
	element.style.left = 0;
	element.style.width = '100%';
	element.style.height = target.clientHeight+'px';
}

function buildTable(data,table) {
	var tbody = byId(table).tBodies[0];
	for(var i = tbody.rows.length-1; i >= 0; i--) {
		tbody.deleteRow(i);
	}
	
	for(var i = 0; i < data.length; i++) {
		var row = app.templates[table].cloneNode(true);
		updateRow(row,data[i]);
		
		byId(table).tBodies[0].appendChild(row);
	}
}

function updateRow(row,rowData) {
	row.ticket_id = rowData.ticket_id;
	var tds = row.getElementsByTagName('td');
	for(var r = 0; r < tds.length; r++) {
		tds[r].innerHTML = tds[r].innerHTML.replace(
		/{\$([a-zA-Z0-9_]+)}/g,
		function(s,k) { 
			return rowData[k];
		}
		);
	}
}
