var loginSetup = function() {
	// Wczanie sekcji komponentw dla zalogowanych uytkownikw
	var li = 'none';
	var lo = 'block';
	if (app.isLoggedIn) {
		li = 'block';
		lo = 'none';
	}
	var els = byClass('loggedIn');
	for(var i = 0; i < els.length; i++) {
		if (els[i].tagName == 'SPAN' && li == 'block') {
			els[i].style.display = 'inline';
		}
		else {
			els[i].style.display = li;
		}
	}
	var els = byClass('loggedOut');
	for(var i = 0; i < els.length; i++) {
		if (els[i].tagName == 'SPAN' && li == 'block') {
			els[i].style.display = 'inline';
		}
		else {
			els[i].style.display = lo;
		}
	}
}
app.setup.push(loginSetup);

var callback = {
	login: function(result) {
		loginComplete(result);
	},
	logout: function(result) {
		logoutComplete(result);
	}
}
var rLogin = new Ticket(callback);

// Komponent do logowania w jzyku JavaScript
function login(form) {
	var username = form.elements.username.value;
	var password = form.elements.password.value;

	rLogin.login(username,password);

	var div = document.createElement('div');
	div.className = 'overlay';
	form.appendChild(div);
	Element.setOpacity(div,.3);
	positionOver(div);
	form.overlay = div;

	return false;
}

function loginComplete(result) {

	var els = byClass('loggedOut',byId('login'));
	var form = els[0];
	form.removeChild(form.overlay);

	if (result) {
		app.profile = result;
		app.isLoggedIn = true;
		byId('loginUsername').innerHTML = 
            app.profile.username;

		loginSetup();
		selectSection('mytickets');
	}
	else {
		setMessage(byId('loginMessage'),'Logowanie nie powiodo si');
	}
	new Effect.Highlight('login');
}

function logout() {
	rLogin.logout();
	return false;
}

function logoutComplete(result) {
	app.isLoggedIn = false;
	app.profile = {};
	loginSetup();

	for(var i = 0; i < app.logout.length; i++) {
		app.logout[i]();
	}

	selectSection('front');
	new Effect.Highlight('login');
}
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
