<?php
require_once 'Ticket.class.php';

$ticket = new Ticket();

$ticket->db->query('truncate tickets');
$ticket->db->query('truncate users');

function dump($input) {
	echo "<pre>";
	var_dump($input);
	echo "</pre><hr>";
}

echo "<h1>Testowanie uytkownikw</h1>";
$id = $ticket->addUser('josh','test','josh@bluga.net');
echo "Dodano uytkownika:<br>";
dump($id);


echo "Wywietlanie uytkownikw:<br>";
dump($ticket->listUsers());


echo "Aktualizowanie uytkownikw:<br>";
// have to be logged in to update your account
$r = $ticket->login('josh','test');
$r = $ticket->updateUser(array('password'=>'test2'));
dump($r);

echo "Wywietlanie uytkownikw:<br>";
dump($ticket->listUsers());


echo "<h1>Test logowania</h1>";
echo "Nieudane logowanie:<br>";
$r = $ticket->login('josh','test');
dump($r);

echo "Udane logowanie:<br>";
$r = $ticket->login('josh','test2');
dump($r);

echo "Sprawdzanie, czy uytkownik jest zalogowany:<br>";
$r = $ticket->isLoggedIn();
dump($r);

echo "Wylogowywanie:<br>";
$r = $ticket->logout();
dump($r);

echo "Sprawdzanie, czy uytkownik jest zalogowany:<br>";
$r = $ticket->isLoggedIn();
dump($r);

echo "Ponowne zalogowanie i pobranie identyfikatora uytkownika:<br>";
$ticket->login('josh','test2');
$r = $ticket->profile('user_id');
dump($r);


echo "<h1>Testowanie zgosze</h1>";

echo "Dodawanie zgoszenia:<br>";
$t = $ticket->addTicket('Zgoszenie testowe','Test');
dump($r);

echo "Wywietlanie nieprzypisanych zgosze:<br>";
$r = $ticket->listUnassignedTickets();
dump($r);

echo "Przypisywanie zgoszenia:<br>";
$since = date('Y-m-d H:i:s');
sleep(1); // Odczekaj wystarczajco dugo, aby sprawdzi, czy zmienna last_changed jest poprawna
$r = $ticket->assignTicket(1,1);
dump($r);

echo "Wywietlanie przypisanych zgosze:<br>";
$r = $ticket->listAssignedTickets();
dump($r);

echo "Aktualizowanie zgosze:<br>";
$r = $ticket->updateTicket(1,array('description'=>'Bla, bla'));
dump($r);

echo "Wywietlanie zaktualizowanych zgosze:<br>";
$r = $ticket->listUpdatedTickets($since.'000',array(1));
dump($r);

$id = $ticket->addTicket('Zgoszenie testowe','bla, bla');
$ticket->assignTicket($id,1);
$ticket->assignTicket(1,false);

echo "Wywietlanie odtworzenej listy zaktualizowanych zgosze:<br>";
$r = $ticket->listUpdatedTickets($since.'000',array(1));
dump($r);
?>
