<?php
// Wersja bez AJAX-a przegldarki wschodw i zachodw soca  

// Doczanie klasy z danymi
require_once 'SunRiseSet.class.php';
$data = new SunRiseSet();

// defaults
$month = 1;
$cities = array('PHOENIX, ARIZONA');

// Wartoci domylne
if (isset($_GET['month'])) {
	$month = (int)$_GET['month'];
}

if (isset($_GET['cities'])) {
	$cities = (array)$_GET['cities'];
}

// Ustawianie wybranych opcji w klasie z danymi
$data->setMonth($month);
$data->setCities($cities);

// Tworzenie acucha znakw zapytania potrzebnego do wygenerowania wykresu
$graphOptions = '';
foreach($cities as $city) {
	$graphOptions .= "cities[]=$city&";
}

$action = htmlentities($_SERVER['PHP_SELF']);
$months = $data->monthList();
?>
<html>
<head>
        <meta http-equiv="content-type" content="text/html; charset=ISO-8859-2">
	<title>Przegldarka wschodw i zachodw</title>
</head>
<body>
<div style="float:left; width: 610px">
<img src="graph.php?<?php echo $graphOptions; ?>"
	width="600" height="400" alt="sun rise and set">

<form action="<?php echo $action; ?>">
<fieldset>
	<legend>Miasta</legend>
	<?php foreach($data->possibleCities()
		as $city) { ?>
	<label><?php echo $city; ?>
		<input type="checkbox" name="cities[]"
		value="<?php echo $city; ?>"
		<?php if(in_array($city,$cities)) { 
			echo "CHECKED"; } ?>>
	</label>

	<?php } ?>
</fieldset>
<label>Wywietl miesic:
<select name="month">
<?php foreach($months as $key => $m) { ?>
	<option value="<?php echo $key;?>"
	<?php if($key == $month) { 
		echo 'SELECTED'; } ?>>
		<?php echo $m; ?></option>
<?php } ?>
</select>
</label>
<input type="submit" value="Aktualizuj widok">
</form>
</div>
<div>
<b><?php echo $months[$month]; ?></b>
<table cellpadding="2" cellspacing="0" 
	border="1">
<thead>
	<tr>
		<th rowspan="2">Dzie</th>
	<?php foreach($cities as $city) { ?>
		<th colspan="2"><?php echo $city; ?></th>
	<?php } ?>
	</tr>
	<tr>
	<?php foreach($cities as $city) { ?>
		<th>Wschd</th>
		<th>Zachd</th>
	<?php } ?>
	</tr>
</thead>
<tbody>
<?php foreach($data->monthsData() as $row) { ?>
	<tr>
		<td><?php echo $row[0]['day']; ?></td>
	<?php foreach($row as $city) { ?>
		<td><?php echo $city['rise']; ?></td>
		<td><?php echo $city['set']; ?></td>
	<?php } ?>
	</tr>
<?php } ?>
</tbody>
</table>
		
</div>
</body>
</html>
<?php /* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */ ?>
