<?php
require_once 'SunRiseSet.class.php';

// Uywa biblioteki Image_Graph http://pear.php.net/Image_Graph z PEAR
require_once 'Image/Graph.php';

$data = new SunRiseSet();

// Wartoci domylne
$cities = array('PHOENIX, ARIZONA');

if (isset($_GET['cities'])) {
	$cities = (array)$_GET['cities'];
}

// Ustawienie wybranych opcji w klasie dostpu do danych
$data->setCities($cities);


// Tworzenie wykresu
$Graph =& Image_Graph::factory('graph', array(600, 400)); 
// Dodawanie czcionki TrueType
$Font =& $Graph->addNew('font', 'Verdana');
// Ustawianie rozmiaru czcionki na 8 pikseli
$Font->setSize(8);

$Graph->setFont($Font);

$Graph->add(
    Image_Graph::vertical(
        Image_Graph::factory('title', array('Wschody i zachody', 12)),
        Image_Graph::vertical(
            $Plotarea = Image_Graph::factory('plotarea'),
            $Legend = Image_Graph::factory('legend'),
            90
        ),
        5
    )
);   
$Legend->setPlotarea($Plotarea);

$colors = array('red','green','blue','orange','gray','purple');
        
// Tworzenie zbioru danych
foreach($cities as $ckey => $city) {
	$Dataset_rise =& Image_Graph::factory('dataset');
	$Dataset_set =& Image_Graph::factory('dataset');
	$points = $data->graphData($city);
	foreach($points as $point) {
		$Dataset_rise->addPoint($point['day'],$point['rise']);
		$Dataset_set->addPoint($point['day'],$point['set']);
	}

	// Tworzenie pierwszej warstwy w postaci wygadzonego wykresu. 
	// Suy do tego pierwszy zbir danych
	$Plot_rise =& $Plotarea->addNew('Image_Graph_Plot_Smoothed_Line', array(&$Dataset_rise));
	$Plot_set =& $Plotarea->addNew('Image_Graph_Plot_Smoothed_Line', array(&$Dataset_set));

	$cityFormated = ucfirst(strtolower(substr($city,0,strpos($city,','))));

	$Plot_rise->setLineColor($colors[$ckey]);
	$Plot_rise->setTitle($cityFormated.' - wschody');
	$Plot_set->setLineColor($colors[$ckey].'@0.2');
	$Plot_set->setTitle($cityFormated.' - zachody');
}

// Formatowanie osi

$Processor =& Image_Graph::factory('Image_Graph_DataPreprocessor_Function', 'formatDay');
$AxisX =& $Plotarea->getAxis(IMAGE_GRAPH_AXIS_X);
$AxisX->setDataPreprocessor($Processor);
$AxisX->setLabelInterval(31);

$Processor =& Image_Graph::factory('Image_Graph_DataPreprocessor_Function', 'formatTime');
$AxisY =& $Plotarea->getAxis(IMAGE_GRAPH_AXIS_Y);
$AxisY->forceMinimum($data->minRise()-50);
$AxisY->setDataPreprocessor($Processor);

// Wywietlanie wykresu
$Graph->done(); 

function formatTime($time) {
	if (strlen($time) == 3) {
		$hour = substr($time,0,1);
		$min = substr($time,1);
	}
	else {
		$hour = substr($time,0,2);
		$min = substr($time,2);
	}

//	$m = 'AM';
//	if ($hour > 12) {
//		$hour = $hour-12;
//		$m = 'PM';
//	}
	return "$hour:$min$m";
}

function formatDay($day) {
	return date('m',strtotime($day));
}
?>
