<?php
class logger {
	var $filename = 'log.txt';

	var $request = '';
	var $fromClient = '';
	var $toClient = '';

	function write() {
		$fp = fopen($this->filename,'a');
		fwrite($fp,$this->request,strlen($this->request));
		fwrite($fp,$this->fromClient,strlen($this->fromClient));
		fwrite($fp,$this->toClient,strlen($this->toClient));
		fclose($fp);
	}

	function logger() {
		$this->storeRequest();
		$this->storeClient();
	}

	function storeRequest() {
		$this->request .= str_repeat('#',80)."\n";
		$this->request .= "Zadanie do: $_SERVER[PHP_SELF]\n";
		$this->request .= "Czas: ".date('Y-m-d H:i:s')."\n\n";
	}

	function storeClient() {
		$this->fromClient .= 'Nieprzetworzony lancuch zapytania: '.$_SERVER['QUERY_STRING']."\n"; 
		$this->fromClient .= "_GET:\n";
		$this->fromClient .= var_export($_GET,true)."\n\n";

		$this->fromClient .= "Nieprzetworzone zadanie POST:\n";
		$this->fromClient .= file_get_contents('php://input')."\n\n";
		$this->fromClient .= "_POST:\n";
		$this->fromClient .= var_export($_POST,true)."\n\n";

		$this->fromClient .= "Naglowki HTTP:\n";

		$headers = array();
		foreach($_SERVER as $name => $val) {
			if (preg_match('/HTTP_(.+)/',$name,$m)) {
				$headers[$m[1]] = $val;
			}
		}
		$other = array('CONTENT_TYPE','CONTENT_LENGTH');
		foreach($other as $o) {
			if (isset($_SERVER[$o])) {
				$headers[$o] = $_SERVER[$o];
			}
		}

		foreach($headers as $n => $v) {
			$this->fromClient .= "$n:$v\n";
		}
		$this->fromClient .= "\n";
	}

	function storeServer($output) {
		$this->toClient .= "Dane przeslane do klienta\n";
		$this->toClient .= $output."\n\n";
	}
}
?>
