function HttpClient() { }
HttpClient.prototype = {
	// Typ GET lub POST przekazywany do funkcji open
	requestType:'GET',
	// Ustawienie na true powoduje zgaszanie wywoa asynchronicznych
	isAsync:false,

	// Zmienna na egzemplarz obiektu XMLHttpRequest
	xmlhttp:false,

	// Kod wywoywany po wywoaniu asynchronicznym zakoczonym
	// powodzeniem
	callback:false,

	// Kod wywoywany po wywoaniu send na obiekcie XMLHttpRequest.
	// Aby zastosowa niestandardowy efekt wczytywania, naley ustawi
	// wasn funkcj dla zdarzenia onSend
	onSend:function() {
		document.getElementById('HttpClientStatus').style.display = 'block';
	},

	// Kod wywoywany, kiedy readyState przyjmie warto 4. Ten kod jest wywoywany
	// przed wywoaniem zwrotnym
	onLoad:function() {
		document.getElementById('HttpClientStatus').style.display = 'none';
	},

	// Kod wywoywany w wyniku wystpienia bdu http
	onError:function(error) {
		alert(error.message);
	},
	
	// Metoda inicjujca obiekt XMLHttpRequest
	init:function() {
		try {
		    // Mozilla / Safari
		    this.xmlhttp = new XMLHttpRequest();
		} catch (e) {
			// IE
			var XMLHTTP_IDS = new Array(
			'MSXML2.XMLHTTP.5.0',
			'MSXML2.XMLHTTP.4.0',
			'MSXML2.XMLHTTP.3.0',
			'MSXML2.XMLHTTP',
			'Microsoft.XMLHTTP' );
			var success = false;
			for (var i=0;i < XMLHTTP_IDS.length && !success; i++) {
				try {
					this.xmlhttp = new ActiveXObject(XMLHTTP_IDS[i]);
					success = true;
				} catch (e) {}
			}
			if (!success) {
				throw new Error('Nie mona utworzy obiektu XMLHttpRequest.');
			}
		}
	},

	// Metoda zgaszajca danie strony	
	// @param string url - Strona, do ktrej kierowane jest danie
	// @param string payload - Wysyane dane, jeli jest to danie typu POST
	makeRequest: function(url,payload) {
		if (!this.xmlhttp) {
			this.init();
		}
		this.xmlhttp.open(this.requestType,url,this.isAsync);

		// Tu naley ustawi onreadystatechange, poniewa w Mozilli stan zostanie wyzerowany
		// po zakoczeniu wywoania
		var self = this;
		this.xmlhttp.onreadystatechange = function() { self._readyStateChangeCallback(); }

		this.xmlhttp.send(payload);

		if (!this.isAsync) {
			return this.xmlhttp.responseText;
		}
	},
	

	// Wewntrzna metoda suca do obsugi zmian stanu
	_readyStateChangeCallback:function() {
		switch(this.xmlhttp.readyState) {
			case 2:
				this.onSend();
				break;
			case 4:
				this.onLoad();
				if (this.xmlhttp.status == 200) {
					this.callback(this.xmlhttp.responseText);
				}
				else {
					this.onError(new Error('Bd HTTP w czasie zgaszania dania: ['+this.xmlhttp.status+'] '+this.xmlhttp.statusText));
				}
			break;
		}
	}
}
