<?php
require_once 'HTML/AJAX/Helper.php';
require_once 'Ticket.class.php';

$app = new Ticket();
$ajax = new HTML_AJAX_Helper();
$ajax->stubs = array('Ticket');
$ajax->jsLibraries = array('All');

// Wczytywanie wartoci
$isLoggedIn = $ajax->jsonEncode($app->isLoggedIn());
$profile = $ajax->jsonEncode($app->profile());
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1250" />
<title>Meneder zgosze</title>
<?php echo $ajax->setupAJAX(); ?>
<script type="text/javascript"
src="scriptaculous/prototype.js"></script>
<script type="text/javascript"
src="scriptaculous/scriptaculous.js"></script>

<script type="text/javascript">
var app = {
	isLoggedIn: <?php echo $isLoggedIn; ?>,
	profile: <?php echo $profile; ?>,
	setup: [],
	logout: [],
	templates: {},
	since: false
}
HTML_AJAX.onError = function(e) {
	alert(HTML_AJAX_Util.quickPrint(e));
}
</script>

<script type="text/javascript"
src="ticket.js"></script>
<script type="text/javascript"
src="components/login.js"></script>
<script type="text/javascript"
src="components/editAccount.js"></script>
<script type="text/javascript"
src="components/myTickets.js"></script>
<script type="text/javascript"
src="components/addTicket.js"></script>
<script type="text/javascript"
src="components/ticketEditor.js"></script>
<script type="text/javascript"
src="components/register.js"></script>
<script type="text/javascript"
src="components/assign.js"></script>


<link rel="stylesheet" href="ticket.css" 
	type="text/css">
</head>
<body onload="setup()">

<div id="header">
<h1>Meneder zgosze</h1>
<div id="nav">
<span><a href="javascript:selectSection('front')"
	>Strona gwna</a></span>

<span class="loggedIn"><a
	href="javascript:selectSection('myTickets')"
	>Moje zgoszenia</a></span>

<span class="loggedIn"><a
	href="javascript:selectSection('addTicket')"
	>Dodaj zgoszenie</a></span>

<span class="loggedIn"><a
	href="javascript:selectSection('assign')"
	>Przypisz zgoszenia</a></span>
<span class="loggedIn"><a
	href="javascript:selectSection('editAccount')"
	>Aktualizuj konto</a></span>
</div>
</div>

<div style="position: relative">

<div id="body">
<div id="front" class="section">
Witamy w menederze zgosze. Zaloguj si, jeli chcesz
doda nowe zgoszenia lub przejrze wasne.

<form onsubmit="return viewTicketForm(this)">
<p id="frontMessage"></p>
<label>ID</label> <input name="id" size="4">
<input type="submit" value="Wywietl zgoszenie">
</form>
</div>
<?php include 'components/register.php'; ?>
<?php include 'components/editAccount.php'; ?>
<?php include 'components/myTickets.php'; ?>
<?php include 'components/addTicket.php'; ?>
<?php include 'components/ticket.php'; ?>
<?php include 'components/assign.php'; ?>
</div>

<div id="sidebar">
<?php include 'components/login.php'; ?>
</div>

</div>

</body>
</html>
