var tCallback = {
	getTicket: function(result) {
		updateTicketForm(result);
	},
	updateTicket: function(result) {
		updateTicketForm(result);
		setMessage(byId('ticketMessage'),
			'Zgoszenie zostao zaktualizowane');
		new Effect.Highlight('tForm');
	}
}

var rTicket = new Ticket(tCallback);

function viewTicket(id) {
	selectSection('ticket');
	rTicket.getTicket(id);
}

function viewTicketForm(form) {
	viewTicket(form.elements.id.value);
	return false;
}

function updateTicket(form) {
	var fields = {};
	fields.title = form.elements.title.value;
	fields.description = form.elements.description.value;

	var a = form.elements.assigned;
	if (a.selectedIndex > 0) {
		fields.assigned = 
			a.value;
	}
	else {
		fields.assigned = false;
	}

	var s = form.elements.status;
	fields.status = s.value;

	rTicket.updateTicket(form.elements.ticket_id.value,
		fields);
	
	return false;
}

function updateTicketForm(values) {
	if (!values) {
		setMessage(byId('frontMessage'),
			"Podane zgoszenie nie istnieje");
		selectSection('front');
		return;
	}

	var t = values.ticket;
	var form = byId('tForm');
	form.elements.title.value = t.title;
	form.elements.description.value = t.description;
	form.elements.ticket_id.value = t.ticket_id;

	byId('lastChanged').innerHTML = t.last_change;
	byId('openedBy').innerHTML = t.creator;
	byId('ticketId').innerHTML = t.ticket_id;

	var status = form.elements.status;
	for(var i = 0; i < status.options.length; i++) {
		if (status.options[i].text == t.status) {
			status.selectedIndex = i;
			break;
		}	
	}

	// Usuwanie aktualnych uytkownikw
	var a = form.elements.assigned;

	for(var i = 1; i < a.options.length; i++) {
		a.remove(i);
	}

	// Dodawanie uytkownikw
	var u = values.users;
	for(var i in u) {
		var o = new Option(u[i],i);
		a.options[a.options.length] = o;
	}

	// Wybr uytkownika
	if (t.assigned) {
		for(var i = 0; i < a.options.length; i++) {
			if (a.options[i].value 
				== t.assigned) {
				a.selectedIndex = i;
				break;
			}	
		}
	}
	else {
		a.selectedIndex = 0;
	}

	if (!app.isLoggedIn) {
		form.submit.value = "Zaloguj si, aby zmodyfikowa";
		form.submit.disabled = true;
	}
	else {
		form.submit.value = "Aktualizuj zgoszenie";
		form.submit.disabled = false;
	}
}
