app.logout.push(function() {
	var tbody = byId('mtTable').tBodies[0];
	for(var i = tbody.rows.length-1; i >= 0; i--) {
		tbody.deleteRow(i);
	}	
	app.since = false;
});

function mtOnDisplay() {
	if (app.since) {
		startUpdate();
	}
	else {
		app.since = new Date();
		rMt.listAssignedTickets();
	}
}

function mtSetup() {
	app.templates['mtTable'] = 
		byId('mtTemplate').cloneNode(true);
	byId('mtTable').tBodies[0].removeChild(
		byId('mtTemplate'));

	byId('myTickets').onDisplay = mtOnDisplay;
	window.setInterval(
	function() {
		if (byId('myTickets').style.display 
			== 'block') {
			startUpdate();
		}
	},30000);

}
app.setup.push(mtSetup);

var mtCallback = {
	listAssignedTickets: function(result) {
		buildTable(result,'mtTable');
	},
	listUpdatedTickets: function(result) {
		updateTable(result);
	}
};
var rMt = new Ticket(mtCallback);

function startUpdate() {
	var since = app.since;
	app.since = new Date();

	var current = [];
	 
	var rows = byId('mtTable').tBodies[0].rows;
	for(var i = 0; i < rows.length; i++) {
		current.push(rows[i].ticket_id);
	}

	byId('mtLoading').style.visibility = 'visible';
	rMt.listUpdatedTickets(since.getTime(),current);
}

function updateTable(data) {
	byId('mtLoading').style.visibility = 'hidden';
	if (data['rebuild']) {
		buildTable(data['tickets'],'mtTable');
		return;
	}
	var tbody = byId('mtTable').tBodies[0];
	for(var i = 0; i < data.length; i++) {
		var row = app.mtTemplate.cloneNode(true);
		updateRow(row,data[i]);

		var replace = -1;
		for(var r = 0; r < tbody.rows.length; r++) {
			if (tbody.rows[r].ticket_id 
				== data[i].ticket_id) {
				replace = r;
				break;
			}
		}

		if (replace == -1) {
			tbody.insertBefore(row,tbody.rows[0]);
		}
		else {
			tbody.removeChild(tbody.rows[replace]);
			tbody.insertBefore(row,tbody.rows[0]);
		}
	}
}
