function aOnDisplay() {
	rAssign.listUsers();
	rAssign.listUnassignedTickets();
}

function aSetup() {
	app.templates['aTable'] = 
		byId('aTemplate').cloneNode(true);
	byId('assign').onDisplay = aOnDisplay;
}
app.setup.push(aSetup);

var aCallback = {
	listUnassignedTickets: function(result) {
		buildTable(result,'aTable');
		makeDragable();
	},
	listUsers: function(result) {
		buildUserDrops(result);
	}
}
var rAssign = new Ticket(aCallback);

function makeDragable() {
	var tbody = byId('aTable').tBodies[0];
	for(var i = 0; i < tbody.rows.length; i++) {
		var td = document.createElement('td');
		var div = document.createElement('div');
		div.innerHTML = 'drag';
		div.className = 'handle';
		td.appendChild(div);
		tbody.rows[i].appendChild(td);
		
		new Draggable(div,
			{revert:true, ghosting: false});
	}
}

function buildUserDrops(users) {
	byId('assignUsers').innerHTML = '';	
	for(var i in users) {
		var div = document.createElement('div');
		div.className = 'user';
		div.innerHTML = users[i];
		div.userId = i;

		byId('assignUsers').appendChild(div);	
		Droppables.add(div,{
		accept: 'handle',
		hoverclass: 'highlight',
		onDrop: function(element, u) {
			assignTicket(element,u);
		}
		});
	}
}

function assignTicket(handle,user) {
	var row = handle.parentNode.parentNode;
	var title = row.cells[1].innerHTML;
	var id = row.cells[0].firstChild.innerHTML;
	rAssign.assignTicket(id,user.userId);

	byId('dragMessage').innerHTML = "Przypisano zgoszenie #"+
		id+" '"+title+"' do "+user.innerHTML;

	row.cells[5].innerHTML = user.innerHTML;
	new Effect.Highlight(row);
}
