--
-- Struktura tabel dla bazy Ticket
--

CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) default '',
  `password` varchar(32) default '',
  `email` varchar(255) default '',
  PRIMARY KEY (user_id)
);

CREATE TABLE `tickets` (
  `ticket_id` int(11) NOT NULL AUTO_INCREMENT,
  `creator` int(11) REFERENCES users(user_id),
  `assigned` int(11) REFERENCES users(user_id),
  `title` varchar(255) default '',
  `description` varchar(255) default '',
  `status` enum('new','open','assigned','fixed') NOT NULL default 'new',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_change` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (ticket_id)
);