<?php
// Konfiguracja bazy danych
$dbHost = 'localhost';
$dbUser = '';
$dbPass = '';
$dbName = 'ticket';

// Ustawienie sesji, jeli nie zostaa jeszcze otwarta
if (!session_id()) {
	session_start();
}

// Klasa dostpu do danych w prostym systemie zgosze
class Ticket {
	var $db;

	var $_ticketQuery = "select 
		t.*, u.username creator, 
		if (a.username is null,'Not Assigned',a.username) assigned_to
		from tickets t 
		inner join users u on t.creator = u.user_id 
		left join users a on t.assigned = a.user_id ";

	function Ticket() {
		$this->db = new mysql();
	}

	function addUser($username,$password,$email) {
		if (empty($username) || empty($password) || empty($email)) {
			return false;
		}
		$u = $this->db->quote($username);
		$p = $this->db->quote($password);
		$e = $this->db->quote($email);
		$sql = "insert into users (username,password,email) values ($u,$p,$e)";

		$userId = $this->db->insert($sql);
		return $userId;
	}

	/* 
	Przykadowe dane wejciowe:
	$fields = array(
		'email' => 'nowy adres e-mail',
		'password' => 'nowe haso'
	);
	*/
	function updateUser($fields) {
		if (!$this->isLoggedIn()) {
			return false;
		}
		unset($fields['user_id']);
		unset($fields['username']);
		$this->db->updateFromArray('users','user_id',$this->profile('user_id'),$fields);

		$sql = "select * from users where user_id = ".$this->profile('user_id');
		$ret = $this->db->queryAll($sql);

		if (isset($ret[0])) {
			unset($ret[0]['password']);
			$_SESSION['profile'] = $ret[0];
			$_SESSION['profile']['loggedIn'] = true;
			return $_SESSION['profile'];
		}
		return false;
	}

	function listUsers() {
		$sql = "select user_id, username from users order by username";
		return $this->db->queryAssoc($sql);
	}


	function addTicket($title,$description) {
		if (!$this->isLoggedIn()) {
			return false;
		}
		$t = $this->db->quote($title);
		$d = $this->db->quote($description);
		$c = $this->db->quote($this->profile('user_id'));
		$sql = "insert into tickets (title,description,creator,created_time,last_change) values ($t,$d,$c,now(),now())";

		$ticketId = $this->db->insert($sql);
		return $ticketId;
	}

	/*
	 Przykadowe dane wejciowe:
	 $fields = array(
		 'title' => 'Nowy tytu',
		 'description' => 'Nowy opis',
		 'status' => 'open',
		 'assigned' => 1
	 );
	*/
	function updateTicket($ticketId,$fields) {
		if (!$this->isLoggedIn()) {
			return false;
		}

                // Pobieranie obiektu dla zmiennej $fields z kodu JavaScript.
                // Ze wzgldu na spjno dane s przeksztacane na tablic.
                // Kod dziaa take wtedy, kiedy dane od razu znajduj si w tablicy.
		$tmp = array();
		foreach($fields as $key => $val) {
			$tmp[$key] = $val;
		}
		$fields = $tmp;

		unset($fields['ticketId']);
		$fields['last_change'] = date('Y-m-d H:i:s');
		if (isset($fields['assigned'])) {
			$this->assignTicket($ticketId,$fields['assigned']);
			unset($fields['assigned']);
		}
		$this->db->updateFromArray('tickets','ticket_id',$ticketId,$fields);
		return $this->getTicket($ticketId);
	}

	function getTicket($ticketId) {
		$t = $this->db->quote($ticketId);
		$sql = $this->_ticketQuery."where ticket_id = $t";
		$t = $this->db->queryAll($sql);

		$users = $this->listUsers();

		if (isset($t[0])) {
			return array('users'=>$users,'ticket'=>$t[0]);
		}
		return false;
	}

	function assignTicket($ticketId,$userId) {
		if (!$this->isLoggedIn()) {
			return false;
		}

		$this->db->updateFromArray('tickets','ticket_id',$ticketId,array('assigned'=>$userId));
		$ret = $this->getTicket($ticketId);

		$status = $ret['ticket']['status'];
		if ($userId == false && $status === 'assigned') {
			$this->updateTicket($ticketId,array('status'=>'open'));
		}
		else if ($status === 'new') {
			$this->updateTicket($ticketId,array('status'=>'assigned'));
		}
		return $ret;
	}

	/* */
	function listUnassignedTickets() {
		$sql = $this->_ticketQuery."where assigned is null order by last_change DESC";
		return $this->db->queryAll($sql);
	}

	function listAssignedTickets() {
		if (!$this->isLoggedIn()) {
			return false;
		}
		$u = $this->db->quote($this->profile('user_id'));
		$sql = $this->_ticketQuery."where assigned = $u order by last_change DESC";
		return $this->db->queryAll($sql);
	}

	function listUpdatedTickets($since,$current) {
		if (!$this->isLoggedIn()) {
			return false;
		}
		if (!strstr('-',$since)) {
			// Znaczniki czasu w JavaScript bazuj na milisekundach, a w PHP - na sekundach
			$since = date('Y-m-d H:i:s',$since/1000);
		}
		$s = $this->db->quote($since);
		$u = $this->db->quote($this->profile('user_id'));

		$list = implode(',',array_map(array($this->db,'quote'),$current));

		$sql = "select count(*) from tickets where (assigned != $u or assigned is null) and ticket_id in($list)";
		if ($this->db->queryOne($sql) > 0) {
			return array('rebuild'=>true,'tickets' => $this->listAssignedTickets());
		}
		$sql = $this->_ticketQuery."where last_change > $s and assigned = $u order by last_change ASC";
		return $this->db->queryAll($sql);
	}

	function login($username,$password) {
		$u = $this->db->quote($username);
		$p = $this->db->quote($password);
		$sql = "select * from users where username = $u and password = $p";
		$ret = $this->db->queryAll($sql);

		if (isset($ret[0])) {
			unset($ret[0]['password']);
			$_SESSION['profile'] = $ret[0];
			$_SESSION['profile']['loggedIn'] = true;
			return $_SESSION['profile'];
		}
		return false;
	}

	function isLoggedIn() {
		if (isset($_SESSION['profile']['loggedIn'])  && $_SESSION['profile']['loggedIn'] === true) {
			return true;
		}
		return false;
	}

	function profile($field = false) {
		if ($this->isLoggedIn()) {
			if ($field) {
				return $_SESSION['profile'][$field];
			}
			return $_SESSION['profile'];
		}
		return false;
	}

	function logout() {
		unset($_SESSION['profile']);
		session_destroy();
		return true;
	}
}

class mysql {
	var $_conn = false;
	function mysql() {
		$this->connect();
	}

	function connect() {
		if ($this->_conn) {
			return true;
		}
		global $dbHost, $dbUser, $dbPass, $dbName;

		$this->_conn = mysql_connect($dbHost,
                        $dbUser,$dbPass);

		if (!$this->_conn) {
			trigger_error(mysql_error());
		}

		mysql_select_db($dbName,$this->_conn);
	}


	function query($sql) {
		$res = mysql_query($sql,$this->_conn);
		if (!$res) {
			trigger_error(mysql_error($this->_conn));
		}
		return $res;
	}

	function queryAll($sql) {
		$res = $this->query($sql);

		$ret = array();
		while($row = mysql_fetch_assoc($res)) {
			$ret[] = $row;
		}
		return $ret;
	}

	function queryAssoc($sql) {
		$res = $this->query($sql);

		$ret = array();
		while($row = mysql_fetch_row($res)) {
			$ret[$row[0]] = $row[1];
		}
		return $ret;
	}

	function querySingleArray($sql) {
		$res = $this->query($sql);

		$ret = array();
		while($row = mysql_fetch_row($res)) {
			$ret[] = $row[0];
		}
		return $ret;
	}

	function queryOne($sql) {
		$res = $this->query($sql);
		if ($row = mysql_fetch_row($res)) {
			return $row[0];
		}
	}

	function quote($input) {
		return "'".mysql_real_escape_string($input,$this->_conn)."'";
		
	}

	function insert($sql) {
		$res = $this->query($sql);
		return mysql_insert_id($this->_conn);
	}

	function updateFromArray($table,$key,$keyValue,$field) {
		$fields = array();
		foreach($field as $k => $v) {
			if ($v == false) {
				$qv = 'null';
			}
			else {
				$qv = $this->quote($v);
			}
			$fields[] = "`$k` = ".$qv;
		}
		$fields = implode(',',$fields);

		$ekv = $this->quote($keyValue);
		$sql = "update $table set $fields where $key = $ekv";
		$res = $this->query($sql);
		return mysql_affected_rows($this->_conn);
	}
}
?>
