<?php
// AJAX version of a sunrise/set viewer
require_once 'ajaxSetup.php';
?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
    <title>AJAX-owa wersja przegldarki wschodw i zachodw soca</title>
<script src="scriptaculous/prototype.js" 
    type="text/javascript"></script>
<script src="scriptaculous/scriptaculous.js" 
    type="text/javascript"></script>
<script src="server.php?client=all"
    type="text/javascript"></script>

<script type="text/javascript">
var cities = {};

function updatePage(form) {
    var queryString = HTML_AJAX.formEncode(form);

    // Sprawdza, czy uytkownik nie wybra innych miast (wtedy odwiea wykres) 
    var els = form.elements;
    for(var i = 0; i < els.length; i++) {
        if (els[i].name == 'cities[]' 
        && cities[els[i].value] != els[i].checked) {
            startLoad(document.getElementById('graph'));
            document.getElementById('graph').src = 
                'graph.php?'+queryString;
            updateCurrentCities();
            break;
        }
    }

    // Po zgoszeniu dania AJAX-a skrypt zastpuje biec 
    // tabel now
    var callback = function(result) {
        document.getElementById('table').innerHTML
         = result;
    }

    // tabel now
    var options = {
        Open: function() {
            document.body.style.cursor = 'progress';
        },
        Load: function() {
            document.body.style.cursor = 'default';
            new Effect.Highlight('table');
        }
    }

    // Zgaszanie dania za pomoc AJAX-a
    HTML_AJAX.grab('ajaxTable.php?'+queryString,
        callback,options);

    // Aktualizacja odnonika do tworzenia zakadek 
    var blink = document.getElementById('blink');
    if (blink.href.indexOf('?') > 0) {
        blink.href = blink.href.substring(
            0,blink.href.indexOf('?'));
    }
    blink.href = blink.href+'?'+queryString;

    return false;
}

// Aktualizacja miast i zapisanie, ktre zostay wybrane
function updateCurrentCities() {
    var els = document.getElementById('form').elements;
    for(var i = 0; i < els.length; i++) {
        if (els[i].name == 'cities[]') {
            cities[els[i].value] = els[i].checked;
        }
    }
}

// Wywietlenie efektu wczytywania na rysunku 
function startLoad(element) {
    if (!element.loading) {
        element.loading = document.createElement('div');
        element.loading.className= 'loading';
        element.loading.innerHTML= 'Wczytywanie, prosz czeka';
        element.loading.style.height = 
            element.clientHeight+'px';
        element.parentNode.appendChild(element.loading);
        element.onload = function() {
            new Effect.Fade(this.loading);
        }
    }
    else {
        new Effect.Appear(element.loading);
    }
}
</script>
<style type="text/css">
.loadable {
    position: relative;
}
.loading {
    position: absolute;
    background-color: #eee;
    text-align: center;
    top: 0;
    left: 0;
    width: 100%;
}
#table {
    float: left;
}
</style>
</head>
<body onload="updateCurrentCities()">
<div style="float:left; width: 610px;">

<div class="loadable">
<img src="graph.php?<?php echo $graphOptions; ?>"
    id="graph" width="600" height="400" 
    alt="sun rise and set">
</div>

<script type="text/javascript">
startLoad(document.getElementById('graph'));
</script>

<form action="<?php echo $action; ?>" id="form"
    onsubmit="return updatePage(this)">
<fieldset>
    <legend>Miasta</legend>
    <?php foreach($data->possibleCities()
        as $city) { ?>
    <label><?php echo $city; ?>
        <input type="checkbox" name="cities[]"
        value="<?php echo $city; ?>"
        <?php if(in_array($city,$cities)) { 
            echo "CHECKED"; 
        } ?>>
    </label>

    <?php } ?>
</fieldset>
<label>Wywietl miesic:
<select name="month">
<?php foreach($months as $key => $m) { ?>
    <option value="<?php echo $key;?>"
    <?php if($key == $month) { echo 'SELECTED'; } ?>>
        <?php echo $m; ?></option>
<?php } ?>
</select>
</label>
<input type="submit" value="Aktualizuj widok">
<a id="blink" href="<?php echo $action; ?>"
    >Odnonik do tworzenia zakadek</a>
</form>
</div>

<div id="table">
<?php include 'ajaxTable.php'; ?>
</div>
</body>
</html>
<?php /* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */ ?>
