<?php
// Obsuga dania danych o wschodach i zachodach soca z bazy danych MySQL

$dbHost = 'localhost';
$dbUser = '';
$dbPass = '';
$dbName = 'rise_set';

class SunRiseSet {
    var $_conn;
    var $month;
    var $year = '2006';
    var $cities = array();
    var $citiesIn = '';

    function setMonth($month) {
        $this->month = $month;
    }

    // Wstpne generowanie nazw miast, co uatwia
    // pisanie zapyta
    function setCities($cities) {
        $this->cities = $cities;
        foreach($cities as $key => $city) {
            $cities[$key] = 
                "'".
                $city //mysql_real_escape_string($city)
                . "'";
        }
        $this->citiesIn = implode(',',$cities);
    }

    // Uywa zapytania sql do pobrania tablicy
    // wszystkich miast z bazy danych
    function possibleCities() {
        $sql = "select 
                    distinct city 
                    from rise_set 
                    order by city
                ";
        return $this->_querySingleArray($sql);
    }

    function monthList() {
        // $ret = array();
          $ret = array(1 => 'Stycze', 'Luty', 'Marzec',
          'Kwiecie', 'Maj', 'Czerwiec', 'Lipiec', 'Sierpie',
          'Wrzesie', 'Padziernik', 'Listopad', 'Grudzie'
        );
        return $ret;
    }

    function monthsData() {
        // Obsuga dat w mysql jest na tyle elastyczna,
        // e mona uy 31-go jako ostatniego dnia kadego
        // miesica
        $sql = "select * 
            from 
                rise_set 
            where 
                `day` between 
                '{$this->year}-{$this->month}-1' and 
                '{$this->year}-{$this->month}-31' 
                and city in($this->citiesIn)
            order by 
                `day`, city";

        $data = $this->_queryAll($sql);

        // Ta ptla czy wiersze z danymi dla rnych miast
        // w pojedynczy wiersz dla kadego dnia
        $ret = array();
        $i = 0;
        $currentDay = $data[0]['day'];
        foreach($data as $row) {
            if ($row['day'] != $currentDay) {
                $currentDay = $row['day'];
                $i++;
            }
            $key = array_search($row['city'],
                    $this->cities, true);
            $ret[$i][$key] = $row;
        }
        return $ret;
    }

    // Wykres obejmuje cay zbir danych, aby nie trzeba
    // ogranicza danych do okrelonego przedziau dat
    function graphData($city) {
        $sql = "select * from rise_set 
        where city = '". ($city)."'
        order by `day` ";

        return $this->_queryAll($sql);
    }

    function minRise() {
        $sql = "select 
                min(rise) mr 
                from rise_set 
                where city in($this->citiesIn)
            ";
        $data = $this->_queryAll($sql);
        return $data[0]['mr'];
    }

    // Bd przy nawizywaniu poczenia ma wstrzymywa wykonywanie skryptu.
    // Jest to minimalistyczna obsuga bdw. Zwykle warto
    // wykonywa dodatkowe operacje
    function _connect() {
        if ($this->_conn) {
            return true;
        }
        global $dbHost, $dbUser, $dbPass, $dbName;

        $this->_conn = mysql_connect($dbHost,
                        $dbUser,$dbPass);

        if (!$this->_conn) {
            die(mysql_error());
        }

        mysql_select_db($dbName,$this->_conn);
    }


    // Uruchamia zapytanie. Bd powoduje zatrzymanie programu
    function _query($sql) {
        $this->_connect();
        $res = mysql_query($sql,$this->_conn);
        if (!$res) {
            die(mysql_error($this->_conn));
        }
        return $res;
    }

    // Pobiera wszystkie wyniki wykonania zapytania i 
    // umieszcza je w tablicy
    function _queryAll($sql) {
        $res = $this->_query($sql);

        $ret = array();
        while($row = mysql_fetch_assoc($res)) {
            $ret[] = $row;
        }
        return $ret;
    }

    // Pobiera wyniki wykonania zapytania i zwraca pierwsze
    // pole w tablicy
    function _querySingleArray($sql) {
        $res = $this->_query($sql);

        $ret = array();
        while($row = mysql_fetch_row($res)) {
            $ret[] = $row[0];
        }
        return $ret;
    }
}
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
?>
