<?php
session_start();

if (!isset($_SESSION['data'])) {
	$_SESSION['data'] = array();
}
if (!isset($_SESSION['id'])) {
	$_SESSION['id'] = false;
}


function startProcess() {
	if (!$_SESSION['id']) {
		$now = time();
		$id = uniqid('m');
		$_SESSION['id'] = $id;
		$_SESSION['data'][$id]['start'] = $now;
		$_SESSION['data'][$id]['name'] = $_GET['process'];
	}
}

function endProcess() {
	$now = time();
	$_SESSION['data'][$_SESSION['id']]['end'] = $now;
	$_SESSION['id'] = false;
}

function printStats() {
	echo "<table border=1><tr><th>Nazwa</th><th>Czas rozpoczcia</th>
		<th>Czas dziaania (w sekundach)</th></tr>";
	foreach($_SESSION['data'] as $process) {
		echo "<tr><td>$process[name]</td><td>".
			date('Y-m-d H:i:s',$process['start']) . 
			'</td><td>';
		if (isset($process['end'])) {
			echo ($process['end'] - $process['start']);
		}
		echo '</td></tr>';
	}
	echo "</table>";
}

switch($_GET['action']) {
	case 'start':
		startProcess();
		break;
	case 'end':
		endProcess();
		break;
	case 'data':
		printStats();
		break;
}
?>
