﻿<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" debug="true">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>1.1</title>
<link rel="stylesheet" type="text/css" href="../includes/style.css" />
<!--[if IE 6]>
<link rel="stylesheet" type="text/css" href="../includes/style_ie6.css" />
<![endif]-->
<!--[if IE]>
<script type="text/javascript" src="../includes/main_ie.lib.js"></script>
<![endif]-->
<script type="text/javascript" src="../includes/main.lib.js"></script>
<script type="text/javascript" src="../includes/ajax.lib.js"></script>
<script type="text/javascript" src="../includes/effects.lib.js"></script>
<script type="text/javascript" src="../includes/firebug/firebug.js"></script>
<script type="text/javascript">

function SimpleDemo() { }
SimpleDemo.prototype = {
	// The AjaxRequest object
	request : null,

	// Setup and send the request
	run : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.addEventListener('load', new Array(this, this.ran));
		this.request.open('GET', 'content.txt');
		return this.request.send();
	},
	
	runRange : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.addEventListener('partialload', new Array(this, this.ran));
		this.request.headers['Range'] = '7524-7600';
		this.request.open('GET', 'content.php');
		return this.request.send();
	},
	
	runInvalidRange : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.headers['Range'] = '7624-7700';
		this.request.addEventListener('requestedrangenotsatisfiable', new Array(this, this.ran));
		this.request.open('GET', 'content.php');
		return this.request.send();
	},
	
	runIfModifiedSince : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.addEventListener('notmodified', new Array(this, this.ran));
		this.request.headers['If-Modified-Since'] = 'Mon, 30 Apr 2007 14:54:44 GMT';
		this.request.open('GET', 'content.txt');
		return this.request.send();
	},
	
	runUnauthorized : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.addEventListener('unauthorized', new Array(this, this.ran));
		this.request.open('GET', 'unauthorized.php');
		return this.request.send();
	},
	
	runNotFound : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.addEventListener('notfound', new Array(this, this.ran));
		this.request.open('GET', 'content.asp');
		return this.request.send();
	},
	
	runInternalError : function() {
		this.request = request_manager.createAjaxRequest();
		this.request.addEventListener('internalservererror', new Array(this, this.ran));
		this.request.open('GET', 'internalerror.php');
		return this.request.send();
	},

	// Triggered when the response returns
	ran : function(event) {
		document.getElementById('status').innerHTML = escapeHTML(event.request.xhr.status + ': ' + event.request.xhr.statusText);
		document.getElementById('output').innerHTML = escapeHTML(event.request.xhr.responseText);
	}
}

window.addEventListener('load', window.viewJSSource, false);

</script>
</head>
<body>

<h1>Example 1.1: a simple Ajax call with callback</h1>

<ol>
	<li><a href="#" onclick="new SimpleDemo().run();return false;" id="runok">Run Complete</a></li>
	<li><a href="#" onclick="new SimpleDemo().runRange();return false;" id="runrange">Run Range</a></li>
	<li><a href="#" onclick="new SimpleDemo().runInvalidRange();return false;" id="runinvalidrange">Run Invalid Range</a></li>
	<li><a href="#" onclick="new SimpleDemo().runIfModifiedSince();return false;" id="runifmodifiedsince">Run If-Modified-Since</a></li>
	<li><a href="#" onclick="new SimpleDemo().runUnauthorized();return false;" id="rununauthorized">Run Unauthorized</a></li>
	<li><a href="#" onclick="new SimpleDemo().runNotFound();return false;" id="runnotfound">Run Not Found</a></li>
	<li><a href="#" onclick="new SimpleDemo().runInternalError();return false;" id="runinternalerror">Run Internal Error</a></li>
</ol>

<div aaa:live="polite" aaa:controls="runok runrange runinvalidrange runifmodifiedsince rununauthorized runnotfound runinternalerror">
	<h2 id="status"> </h2>
	<pre class="demo" id="output"> </pre>
</div>

</body>
</html>
