<?php

$headers = apache_request_headers();
$cache = 'content.txt';
$range = explode('-', $headers['Range']);
$start = (int)$range[0];
$end = ($range[1] === '' || (int)$range[1] < $start) ? null : (int)$range[1] - $start;

// Invalid range?
if ($start < 0 || $end < 0 || $start > filesize($cache)) {
	header('HTTP/1.1 416 Requested Range Not Satisfiable');
	exit();
}

if ($handle = fopen($cache, 'r')) {
	header('HTTP/1.1 206 Partial Content');
	fseek($handle, $start);
	echo fread($handle, $end);
}
fclose($handle);

?>
