<?php

class Messenger {
	protected $message_queue;
	protected $count;
	
	public function hasMessages() {
		return $this->count > 0;
	}
	
	public function getMessages() {
		return $this->message_queue['messages'];
	}
	
	public function getErrors() {
		return $this->message_queue['errors'];
	}
	
	public function getQueue() {
		return $this->message_queue;
	}

	public function getErrorCount() {
		return count($this->message_queue['errors']);
	}

	public function getMessageCount() {
		return count($this->message_queue['messages']);
	}
	
	public function addError($msg) {
		$this->count++;
		$this->message_queue['errors'][] = $this->err_prefix . $msg;
	}
	
	public function addMessage($msg) {
		$this->count++;
		$this->message_queue['messages'][] = $this->msg_prefix . $msg;
	}
	
	public function __construct() {
		$this->message_queue = array(
			'errors' => array(),
			'messages' => array()
		);
		$this->count = 0;
	}
}

?>
