<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" debug="true">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>Example: DOM methods to outline the last list item of each emulated unordered list</title>
<link rel="stylesheet" type="text/css" href="../includes/style.css" />
<!--[if IE 6]>
<link rel="stylesheet" type="text/css" href="../includes/style_ie6.css" />
<![endif]-->
<!--[if IE]>
<script type="text/javascript" src="../includes/main_ie.lib.js"></script>
<![endif]-->
<script type="text/javascript" src="../includes/main.lib.js"></script>
<script type="text/javascript" src="../includes/firebug/firebug.js"></script>
<style type="text/css">

.ul, .ol {
	margin: 1em 0 1em 0;
	padding: 0 0 0 40px;
}
.li > .ul, .li > .ol {
	margin: 0;
}
.ul > .li {
	display: list-item;
	list-style: disc outside;	
}
.li > .ul > .li {
	list-style-type: circle;
}
.ol > .li {
	counter-increment: 1;
	display: list-item;
	list-style: decimal outside;
}

</style>
<script type="text/javascript">

function select() {
	var post_divs = document.getElementById('demo_dom').getElementsByTagName('div');
	for (var i = 0; i < post_divs.length; i++) {
		var current_div = post_divs.item(i);
		if (!current_div.attributes) {
			continue;
		}
		// Supporting IE, Opera, Safari and Mozilla takes two routes
		var current_class = current_div.attributes['class'];
		if (current_class) {
			current_class = current_class.value;
		} else if (current_div.getAttribute) {
			current_class = current_div.getAttribute('class');
		}
		if (current_class) {
			var classes = current_class.split(' ');
			// Since only Mozilla (currently) supports Array.prototype.indexOf
			for (var j = 0; j < classes.length; j++) {
				if (classes[j] == 'ul') {
					var last_li = current_div.lastChild;
					while (last_li) {
						if (last_li.nodeType == 1) {
							last_li.style.backgroundColor = '#000';
							break;
						} else {
							last_li = last_li.previousSibling;
						}
					}
					break;
				}
			}
		}
	}
}

window.addEventListener('load', window.viewJSSource, false);

</script>
</head>
<body>

<h1>Example: DOM methods to outline the last list item of each emulated unordered list</h1>

<div class="run_demo">
	<a href="#" onclick="select();return false;">Run Demo</a>
	<p>(Note: this displays properly in IE7, Opera, and Safari. Mozilla still works, but it does not support <code>counter-increment</code> as necessary for the ordered list items.)</p>
</div>

<h2>XHTML Elements</h2>

<div class="demo">
	<div id="demo_dom">
		<div class="post">
			<h3>Post title</h3>
			<div>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</div>
			<div class="ul">
				<div class="li">
					something
					<div class="ul"><div class="li">number 1</div><div class="li">number 2</div></div>
				</div>
				<div class="li">something</div>
				<div class="li">something</div>
			</div>
			<div>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</div>
		</div>
		<div class="post">
			<h3>Post title</h3>
			<div>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</div>
			<div class="ol">
				<div class="li">something</div>
				<div class="li">something</div>
				<div class="li">something</div>
			</div>
			<div>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</div>
		</div>
		<div class="post">
			<h3>Post title</h3>
			<div>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</div>
			<div class="ul">
				<div class="li">
					something
					<div class="ol"><div class="li">number 1</div><div class="li">number 2</div></div>
				</div>
				<div class="li">something</div>
				<div class="li">something</div>
			</div>
			<div>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</div>
		</div>
	</div>
</div>

<h2>XHTML Source</h2>

<pre class="demo">
&lt;div id="demo_dom"&gt;
	&lt;div class="post"&gt;
		&lt;h3&gt;Post title&lt;/h3&gt;
		&lt;div&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/div&gt;
		&lt;div class="ul"&gt;
			&lt;div class="li"&gt;
				something
				&lt;div class="ul"&gt;&lt;div class="li"&gt;number 1&lt;/div&gt;&lt;div class="li"&gt;number 2&lt;/div&gt;&lt;/div&gt;
			&lt;/div&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
		&lt;/div&gt;
		&lt;div&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/div&gt;
	&lt;/div&gt;
	&lt;div class="post"&gt;
		&lt;h3&gt;Post title&lt;/h3&gt;
		&lt;div&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/div&gt;
		&lt;div class="ol"&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
		&lt;/div&gt;
		&lt;div&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/div&gt;
	&lt;/div&gt;
	&lt;div class="post"&gt;
		&lt;h3&gt;Post title&lt;/h3&gt;
		&lt;div&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/div&gt;
		&lt;div class="ul"&gt;
			&lt;div class="li"&gt;
				something
				&lt;div class="ol"&gt;&lt;div class="li"&gt;number 1&lt;/div&gt;&lt;div class="li"&gt;number 2&lt;/div&gt;&lt;/div&gt;
			&lt;/div&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
			&lt;div class="li"&gt;something&lt;/div&gt;
		&lt;/div&gt;
		&lt;div&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/div&gt;
	&lt;/div&gt;
&lt;/div&gt;
</pre>

<h2>JavaScript</h2>

</body>
</html>
