<?php

class XHTMLRenderingEngine extends RenderingEngine {
	protected $headers = array(
		'Content-Type' => 'application/xhtml+xml;charset=utf-8'
	);
	
	/**
	 * Override in order to send text/html for those that don't support it
	 */
	public function sendHeaders() {
		global $controller;
		$accept = $controller->getHeader('Accept');
		if (!$accept || strpos($accept, 'application/xhtml+xml') === false) {
			$this->headers['Content-Type'] = 'text/html;charset=utf-8';
		}
		return parent::sendHeaders();
	}
	
	/**
	 * A shorter, aliased way of escaping XML entitites
	 */
	public function escape($string) {
		return Utilities::escapeXMLEntities($string);
	}
}

?>