<?php

/**
 * A drastically simplified Message object in order to keep the example readable
 */
class Message {
	public $content;
	public $type;

	public function __construct($content = '', $type = 'message') {
		$this->content = $content;
		$this->type = $type;
	}
}

class Messenger {
	// The $message_queue holds all types of messages in order to
	// return all of them at once if and when requested
	protected $message_queue;
	// Holds references to arrays of messages by type
	protected $message_types;
	
	/**
	 * Returns the entire queue or a specified type
	 */
	public function getQueue($type = null) {
		if ($type) {
			if (isset($this->message_types[$type])) {
				return $this->message_types[$type];
			} else {
				return array();
			}
		} else {
			return $this->message_queue;
		}
	}

	/**
	 * Add a message to the specified queue
	 */
	public function add($message, $type) {
		$message_object = $this->message_queue[] = new Message($message, $type);
		if (!isset($this->message_types[$type])) {
			$this->message_types[$type] = array($message_object);
		} else {
			$this->message_types[$type][] = $message_object;
		}
	}
	
	/**
	 * Creates the initial queue array
	 */
	public function __construct() {
		$this->message_queue = array();
		$this->message_types = array();
	}
}

?>