<?php

Utilities::loadModel('DBO');

class User extends DBO {
	protected $table = 'users';
	protected $fields = array(
		'id' => null,
		'login' => null,
		'name' => null,
		'email' => null,
		'password' => null,
		'created' => null
	);
	/**
	 * Since the User id and created fields only get calculated,
	 * only the other fields need constraints
	 */
	protected $fields_constraints = array(
		'login' => array('type' => 'string', 'size' => 255),
		'name' => array('type' => 'string', 'size' => 255),
		'email' => array('type' => 'string', 'size' => 255),
		'password' => array('type' => 'string', 'size' => 40)
	);
	public $session;
	
	public function set($field, $value) {
		if ($field == 'password') {
			// throws PasswordFormatException
			self::assertPasswordFormat($value);
			$value = Utilities::hashWithSalt($value);
		} else if ($field == 'email') {
			// throws EmailFormatException
			User::assertEmailFormat($value);
		} else if ($field != 'name' || $field != 'login') {
			return false;
		}
		return parent::set($field, $value);
	}
	
	public function authenticate() {
		if ($this->session->load()) {
			if ($userid = $this->session->get('user')) {
				if ($this->load($userid)) {
					return true;
				} else {
					// handle corrupted session record returning an invalid userid
				}
			} else {
				// handle anonymous session
			}
		} else {
			// handle a completely new session
		}
	}
	
	public function __construct($id = null) {
		parent::__construct($id);
		Utilities::loadModel('Session');
		$this->session = new Session();
	}
	
	public static function assertEmailFormat($string) {
		global $config;
		if (!preg_match($config['regex']['email'], $string)) {
			throw new EmailFormatException();
		}
	}
	
	public static function assertPasswordFormat($string) {
		global $config;
		if (!preg_match($config['regex']['password'], $string)) {
			throw new PasswordFormatException();
		}
	}
}

class EmailFormatException extends Exception {
	public function __construct() {
		$this->message = 'Say something bad about the email format.';
	}
}

class PasswordFormatException extends Exception {
	public function __construct() {
		$this->message = 'Say something bad about the password format.';
	}
}

?>