<?php

Utilities::loadModel('User');

class defaultController {
	// References to the globals
	protected $raw_get;
	protected $raw_post;
	protected $raw_request;
	// A reference to the user object created here
	protected $user;
	protected $userinfo = array(
		'login' => null,
		'name' => null,
		'email' => null,
		'password' => null
	);
	// What actually handles the output
	protected $view;
	// How we'll need to answer requests
	protected $method;
	
	/**
	 * Get the request method from the View, instantiate the rendering engine,
	 * set the rendering context to this file's directory, filter the request,
	 * and attempt to create the user record from the request data.
	 */
	public function handleRequest($get, $post = null, $request = null) {
		// Create the rendering engine
		$this->method = View::getMethodFromRequest($get);
		$this->view = View::getRenderingEngine($this->method);
		$this->view->setContext(dirname(__FILE__));
		// Filter the request
		$this->filterRequest($get, $post, $request);
		// Attempt to create the new user record with the filtered request
		$this->createUser();
	}
	
	/**
	 * Only accept the request data if the CentralController validates the
	 * header, or the post value if a full page load (form submission)
	 */
	public function filterRequest($get, $post = null, $request = null) {
		global $controller;
		
		if ($controller->validateHeader()
				|| ($this->method == View::$METHOD_XHTML && $controller->validatePost())) {
			$this->raw_get = $get;
			$this->raw_post = (is_null($post)) ? array() : $post;
			$this->raw_request = (is_null($request)) ? array() : $request;
		} else {
			return false;
		}
	}
	
	/**
	 * Attempt to create the user record if all fields exist,
	 * passing off any exception messages to the Messenger
	 */
	protected function createUser() {
		global $messenger;
		
		$this->user = new User();
		if ($this->getUserInfo()) {
			$errors_found = false;
			foreach ($this->userinfo as $field => $value) {
				if (isset($value)) {
					try {
						$this->user->set($field, $value);
					} catch (Exception $e) {
						if (!$errors_found) {
							$errors_found = true;
						}
						$messenger->add($e->getMessage(), $field);
					}
				}
			}
			if (!$errors_found) {
				try {
					$this->user->save();
				} catch (Exception $e) {
					$messenger->add($e->getMessage(), 'error');
				}
			}
		}
	}
	
	/**
	 * Pull the values of each user field out of the post request,
	 * with the stipulation that the password and confirmation must
	 * match each other.
	 */
	public function getUserInfo() {
		global $messenger;
		foreach ($this->userinfo as $field => $value) {
			if (isset($this->raw_post[$field])) {
				if ($field == 'login' && User::loginExists($value)) {
					$messenger->add('Login already in use', 'login');
					continue;
				} else if ($field == 'password') {
					if (!isset($this->raw_post['password_confirm'])
							|| $this->raw_post[$field] != $this->raw_post['password_confirm']) {
						$messenger->add('Password and confirmation must match', 'password');
						continue;
					}
				}
				$this->userinfo[$field] = $this->raw_post[$field];
			}
		}
		return !in_array(null, $this->userinfo);
	}
	
	/**
	 * Display the output of the rendering engine, using the
	 * appropriate template for the given request method
	 */
	public function display() {
		switch ($this->method) {
			case View::$METHOD_JSON:
				$this->view->setTemplate('json.php');
				break;
			case View::$METHOD_XML:
				$this->view->setTemplate('xml.php');
				break;
			case View::$METHOD_XHTML:
			default:
				$this->view->setTemplate('index.php');
				break;
		}
		$this->view->sendHeaders();
		$this->view->display();
	}
}

?>
