<?php

Utilities::loadClass('Messenger');
Utilities::loadClass('View', 'views');

global $messenger;
$messenger = new Messenger();

$controllers = array(
	'default' => array(
		'class' => 'defaultController',
		'filename' => 'default'
	),
	'game' => array(
		'class' => 'gameController',
		'filename' => 'game'
	)
);

/**
 * The central controller of the application.
 */
class CentralController {
	/**
	 * @var array $config Alias to configuration array
	 */
	public $config;
	/**
	 * @var array $raw_get Reference to the $_GET superglobal
	 */
	protected $raw_get;
	/**
	 * @var array $raw_post Reference to the $_POST superglobal
	 */
	protected $raw_post;
	/**
	 * @var array $raw_request Reference to the $_REQUEST superglobal
	 */
	protected $raw_request;
	/**
	 * @var array $raw_headers Reference to an array of request headers
	 */
	protected $raw_headers;
	/**
	 * @var array $controller The controller for the given part
	 */
	protected $controller;
	// A reference to the current user
	protected $user;
	// A boolean flag as to whether the validation token matched
	protected $validated = false;
	protected $validation_token;
	
	public function handleRequest($get, $post = null, $request = null) {
		$this->raw_get = $get;
		$this->raw_post = (is_null($post)) ? array() : $post;
		$this->raw_request = (is_null($request)) ? array() : $request;
		try {
		//	$this->loadUser();
			$this->loadController();
			$this->passTheBuck();
		} catch (Exception $e) {
			exit($e->getMessage());// throw fatal error page
		}
	}
	
	protected function loadUser() {
		try {
			Utilities::loadModel('User');
			$this->user = new User();
			$this->user->authenticate();
		} catch (Exception $e) {
			exit($e->getMessage());
		}
	}

	protected function loadController() {
		global $controllers;
		
		// If no valid controller specified, fall back to default
		$controller_key = 'default';
		if (isset($this->raw_get['c']) && isset($controllers[$this->raw_get['c']])) {
			$controller_key = $this->raw_get['c'];
		}
		// Find the controller or throw an Exception
		$controller_path = 'controllers/'
				. $controllers[$controller_key]['filename'] . '/'
				. $controllers[$controller_key]['filename'] . '.php';
		// Just in case the file moved since generating the list of
		// available controllers, check before loading
		if (!file_exists($controller_path)) {
			throw new Exception('Controller not found');
		}
		// Generate the request validation token
		//$this->generateValidationToken($controller_key);
		// Load the file and instantiate the controller
		include $controller_path;
		$this->controller = new $controllers[$controller_key]['class']();
		return true;
	}
	
	/**
	 * A simple method to lazy-load the HTTP request headers and return
	 * the requested value if it exists.
	 */
	public function getHeader($key) {
		// Late-load apache headers
		if (!isset($this->raw_headers)) {
			$this->raw_headers = apache_request_headers();
		}
		if (isset($this->raw_headers[$key])) {
			return $this->raw_headers[$key];
		} else {
			return false;
		}
	}
	
	/**
	 * Get a token based on the current area of the application,
	 * but only if the user has changed from a different area.
	 */
	protected function generateValidationToken($area) {
		// Get the last viewed area as stored in the session
		$last_viewed = $this->user->session->get('last_viewed_area');
		// If different than this area, regenerate the token and apply to the session
		if ($area != $last_viewed) {
			$session = $this->user->session->get('id');
			$this->validation_token = Utilities::generateToken($area . $session);
			$this->user->session->set('last_viewed_area', $area);
		}
	}
	
	/**
	 * Validates the token against the request headers
	 */
	public function validateHeader() {
		return $this->validateToken($this->getHeader($this->config['settings']['validation']));
	}
	
	/**
	 * Validates the token against the POST data
	 */
	public function validatePost() {
		if (isset($this->raw_post[$this->config['settings']['validation']])) {
			return $this->validateToken($this->raw_post[$this->config['settings']['validation']]);
		}
	}
	
	/**
	 * Validate that the current token and the one from the request match
	 */
	public function validateToken($test) {
		return ($test === $this->validation_token);
	}

	protected function passTheBuck() {
		$this->controller->handleRequest($this->raw_get, $this->raw_post, $this->raw_request);
	}
	
	public function getDatabaseHandle() {
		if (!isset($this->database)) {
			$this->loadDatabase();
		}
		return $this->database;
	}
	
	protected function loadDatabase() {
		$this->database = new PDO(
			$this->config['database']['dsn'],
			$this->config['database']['username'],
			$this->config['database']['password'],
			$this->config['database']['options']
		);
	}

	public function display() {
		$this->controller->display();
	}
	
	public function __construct() {
		include 'configuration.php';
		$this->config = $config;
	}
}

?>
