<?php

class PDOIterator implements Iterator {
	/**
	 * The PDO connection object
	 */
	protected $database;
	protected $statement;
	/**
	 * The query to run on the first iteration
	 */
	protected $query;
	/**
	 * Optional parameters to use for prepared statements
	 */
	protected $parameters;
	/**
	 * The current record in the results
	 */
	protected $current;
	/**
	 * The row number of the current record
	 */
	protected $key;
	/**
	 * A boolean as to whether it has more results
	 */
	protected $valid;

	/**
	 * Forward-only cursor assumed and enforced
	 */
	public function rewind() {
		return false;
	}
	
	public function current() {
		if ($this->key === -1) {
			if (!$this->runQuery()) {
				$this->valid = false;
				return false;
			} else {
				$this->next();
			}
		}
		return $this->current;
	}
	
	public function key() {
		return $this->key;
	}
	
	public function next() {
		$this->current = $this->statement->fetch(PDO::FETCH_ASSOC);
		if ($this->current) {
			$this->key++;
			if (!$this->valid) {
				$this->valid = true;
			}
			return true;
		} else {
			$this->statement = null;
			$this->valid = false;
			return false;
		}
	}
	
	protected function runQuery() {
		$this->statement = $this->database->prepare($this->query);
		$this->statement->execute($this->parameters);
	}
	
	public function valid() {
		return $this->valid;
	}
	
	public function setParameters($params) {
		$this->parameters = $params;
	}
	
	public function __construct($database, $query) {
		$this->database = $database;
		$this->query = $query;
		$this->parameters = null;
		$this->current = null;
		$this->key = -1;
		$this->valid = true;
	}
}

// First, run the query and get the list
$database = new PDO('mysql:host=127.0.0.1;dbname=ajax', 'ajax', 'ajax');
$query = 'SELECT `id`, `name` FROM `users`';
$users = new PDOIterator($database, $query);
?>

<!-- Later in the application, output the list -->
<ol>
<?php foreach ($users as $user) { ?>
	<li><a href="?id=<?php echo (int)$user['id']; ?>">
		<?php
		echo $user['name'];
		?>
	</a></li>
<?php } ?>
</ol>
