<?php

$scripts = array(
	'../includes/main.lib.js',
	'../includes/ajax.lib.js',
	'../includes/effects.lib.js',
	'main.lib.js',
	'ajax.lib.js',
	'effects.lib.js'
);
$cache = 'cache/lib.js';

function consolidate($files, $cache) {
	$lastupdated = file_exists($cache) ? filemtime($cache) : 0;
	$generate = false;
	foreach ($files as $file) {
		// Just stop of missing a source file
		if (!file_exists($file)) {
			return false;
		}
		if ($u = filemtime($file) > $lastupdated) {
			$generate = true;
			break;
		}
	}
	// Files changed since the last cache modification
	if ($generate) {
		$temp = tempnam('/tmp', 'cache');
		$temph = fopen($temp, 'w');
		// Now write each of the files to it
		foreach ($files as $file) {
			$fileh = fopen($file, 'r');
			while (!feof($fileh)) {
				fwrite($temph, fgets($fileh));
			}
			fclose($fileh);
		}
		fclose($temph);
		rename($temp, $cache);
	}
	return true;
}

consolidate($scripts, $cache);

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>1.1</title>
<link rel="stylesheet" type="text/css" href="../includes/style.css" />
<!--[if IE 6]>
<link rel="stylesheet" type="text/css" href="../includes/style_ie6.css" />
<![endif]-->
<!--[if IE]>
<script type="text/javascript" src="../includes/main_ie.lib.js"></script>
<![endif]-->
<script type="text/javascript" src="cache/lib.js"></script>
<script type="text/javascript">

var Foo = { };
Foo.bar = function() { };
Foo.bar.prototype = { };
Foo.bar.prototype.baz = function(a) {
	alert(a);
}

</script>
</head>
<body>

</body>
</html>
