<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" debug="true">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>Example: DOM methods to outline the last list item of each unordered list</title>
<link rel="stylesheet" type="text/css" href="../includes/style.css" />
<!--[if IE 6]>
<link rel="stylesheet" type="text/css" href="../includes/style_ie6.css" />
<![endif]-->
<!--[if IE]>
<script type="text/javascript" src="../includes/main_ie.lib.js"></script>
<![endif]-->
<script type="text/javascript" src="../includes/main.lib.js"></script>
<script type="text/javascript" src="../includes/firebug/firebug.js"></script>
<script type="text/javascript">

function select() {
	var post_lists = document.getElementById('demo_dom').getElementsByTagName('ul');
	for (var i = 0; i < post_lists.length; i++) {
		var last_li = post_lists.item(i).lastChild;
		while (last_li) {
			if (last_li.nodeType == 1) {
				last_li.style.backgroundColor = '#000';
				break;
			} else {
				last_li = last_li.previousSibling;
			}
		}
	}
}

window.addEventListener('load', window.viewJSSource, false);

</script>
</head>
<body>

<h1>Example: DOM methods to outline the last list item of each unordered list</h1>

<div class="run_demo">
	<a href="#" onclick="select();return false;">Run Demo</a>
</div>

<h2>XHTML Elements</h2>

<div class="demo">
	<div id="demo_dom">
		<div class="post">
			<h3>Post title</h3>
			<p>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</p>
			<ul>
				<li>
					something
					<ul><li>number 1</li><li>number 2</li></ul>
				</li>
				<li>something</li>
				<li>something</li>
			</ul>
			<p>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</p>
		</div>
		<div class="post">
			<h3>Post title</h3>
			<p>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</p>
			<ol>
				<li>something</li>
				<li>something</li>
				<li>something</li>
			</ol>
			<p>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</p>
		</div>
		<div class="post">
			<h3>Post title</h3>
			<p>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</p>
			<ul>
				<li>
					something
					<ol><li>number 1</li><li>number 2</li></ol>
				</li>
				<li>something</li>
				<li>something</li>
			</ul>
			<p>Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.</p>
		</div>
	</div>
</div>

<h2>XHTML Source</h2>

<pre class="demo">
&lt;div id="demo_dom"&gt;
	&lt;div class="post"&gt;
		&lt;h3&gt;Post title&lt;/h3&gt;
		&lt;p&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/p&gt;
		&lt;ul&gt;
			&lt;li&gt;
			something
			&lt;ul&gt;&lt;li&gt;number 1&lt;/li&gt;&lt;li&gt;number 2&lt;/li&gt;&lt;/ul&gt;
			&lt;/li&gt;
			&lt;li&gt;something&lt;/li&gt;
			&lt;li&gt;something&lt;/li&gt;
		&lt;/ul&gt;
		&lt;p&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/p&gt;
	&lt;/div&gt;
	&lt;div class="post"&gt;
		&lt;h3&gt;Post title&lt;/h3&gt;
		&lt;p&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/p&gt;
		&lt;ol&gt;
			&lt;li&gt;something&lt;/li&gt;
			&lt;li&gt;something&lt;/li&gt;
			&lt;li&gt;something&lt;/li&gt;
		&lt;/ol&gt;
		&lt;p&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/p&gt;
	&lt;/div&gt;
	&lt;div class="post"&gt;
		&lt;h3&gt;Post title&lt;/h3&gt;
		&lt;p&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/p&gt;
		&lt;ul&gt;
			&lt;li&gt;
			something
			&lt;ol&gt;&lt;li&gt;number 1&lt;/li&gt;&lt;li&gt;number 2&lt;/li&gt;&lt;/ol&gt;
			&lt;/li&gt;
			&lt;li&gt;something&lt;/li&gt;
			&lt;li&gt;something&lt;/li&gt;
		&lt;/ul&gt;
		&lt;p&gt;Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text. Lots of post text.&lt;/p&gt;
	&lt;/div&gt;
&lt;/div&gt;
</pre>

<h2>JavaScript</h2>

</body>
</html>
