<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<title>Comparing Differences in CSS Support</title>
<link rel="stylesheet" type="text/css" href="../includes/style.css" />
<script type="text/javascript" src="../includes/main.lib.js"></script>
<script type="text/javascript" src="../includes/ajax.lib.js"></script>
<script type="text/javascript" src="../includes/effects.lib.js"></script>
<script type="text/javascript" src="../includes/firebug/firebug.js"></script>
<style type="text/css">

.demo p {
	clear: both;
	margin: 1em;
}
.demo p:first-child:first-letter {
	display: block;
	float: left;
	font-size: 3em;
	font-style: italic;
	line-height: .7em;
	text-indent: .2em;
	text-shadow: 4px 4px 3px #000;
	width: 1em;
}

</style>
</head>
<body>

<h1>Comparing Differences in CSS Support</h1>

<div class="demo">
	<p>Edgar Allen Poe, as an editor, once wrote something to the effect that in short stories, every word of every sentence needs to contribute to the piece as a whole. Anything else wastes the page's space and the readers' time, and should get cut.</p>
	<p>When it comes to user interfaces, this also rings true for everything on the page, whether text, form element, or media. Especially with regard to newly adopted technologies, those using them tend to overdo it.</p>
</div>

<h2>CSS</h2>

<pre class="demo">.demo p {
	clear: both;
	margin: 1em;
}
.demo p:first-child:first-letter {
	display: block;
	float: left;
	font-size: 3em;
	font-style: italic;
	line-height: .7em;
	text-indent: .2em;
	text-shadow: 4px 4px 3px #000;
	width: 1em;
}</pre>

<h2>Browser Comparisons</h2>

<div class="demo" style="margin: 0 10%; 0 10%;">
	<div class="one">
		<h3>IE6</h3>
		<img src="IE6.tiff" alt="IE6 showing a general lack of any CSS support" />
	</div>
	
	<div class="two">
		<h3>IE7</h3>
		<img src="IE7.tiff" alt="IE6 showing a general lack of any CSS support" />
	</div>

	<div class="one">
		<h3>Mozilla</h3>
		<img src="Mozilla.tiff" alt="IE6 showing a general lack of any CSS support" />
	</div>
	
	<div class="two">
		<h3>Opera</h3>
		<img src="Opera.tiff" alt="IE6 showing a general lack of any CSS support" />
	</div>

	<div class="one">
		<h3>Safari</h3>
		<img src="Safari.tiff" alt="IE6 showing a general lack of any CSS support" />
	</div>
</div>

</body>
</html>
