function init() {
    var oXmlDom = zXmlDom.createDocument();
    oXmlDom.onreadystatechange = function () {
        if (oXmlDom.readyState == 4) {
            if (oXmlDom.parseError.errorCode == 0) {
                parseBookInfo(oXmlDom);
            } else {
                var str = "Wystpi bd!!\n" +
                    "Opis: " + oXmlDom.parseError.reason + "\n" +
                    "Plik: " + oXmlDom.parseError.url + "\n" +
                    "Wiersz: " + oXmlDom.parseError.line + "\n" +
                    "Pozycja w wierszu: " + oXmlDom.parseError.linepos + "\n" +
                    "Kod rdowy: " + oXmlDom.parseError.srcText;

                alert(str);
            }
        }
    };
    oXmlDom.load("books.xml");
}

function parseBookInfo(oXmlDom) {
    var oRoot = oXmlDom.documentElement;
    var oFragment = document.createDocumentFragment();
    
    var aBooks = oRoot.getElementsByTagName("book");
    
    for (var i = 0; i < aBooks.length; i++) {
        var sIsbn = aBooks[i].getAttribute("isbn");
        var sAuthor, sTitle, sPublisher;
        
        var oCurrentChild = aBooks[i].firstChild;

        do {
            switch (oCurrentChild.tagName) {
                case "title":
                    sTitle = oCurrentChild.text;
                break;
                case "author":
                    sAuthor = oCurrentChild.text;
                break;
                case "publisher":
                    sPublisher = oCurrentChild.text;
                break;
                default:
                break;
            }
        } while (oCurrentChild = oCurrentChild.nextSibling);
        
        var divContainer = document.createElement("div");
        var imgBookCover = document.createElement("img");
        var divContent = document.createElement("div");
        
        var sOdd = (i % 2)?"":"-odd";
        divContainer.className = "bookContainer" + sOdd;
        
        imgBookCover.src = "images/" + sIsbn + ".png";
        imgBookCover.className = "bookCover";
        divContainer.appendChild(imgBookCover);
        
        var h3Title = document.createElement("h3");
        h3Title.appendChild(document.createTextNode(sTitle));
        divContent.appendChild(h3Title);
        
        divContent.appendChild(document.createTextNode("Autor: " + sAuthor));
        divContent.appendChild(document.createElement("br"));
        divContent.appendChild(document.createTextNode("ISBN: #" + sIsbn));
        
        var divPublisher = document.createElement("div");
        divPublisher.className = "bookPublisher";
        divPublisher.appendChild(document.createTextNode("Wydawca: " + sPublisher));
        divContent.appendChild(divPublisher);
        
        divContent.className = "bookContent";
        divContainer.appendChild(divContent);
        
        oFragment.appendChild(divContainer);
    }
    document.body.appendChild(oFragment);
}



onload = init;