/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Call;
import uk.ltd.getahead.dwr.Calls;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.ExecutionContext;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class ExecuteQuery {
    private static final Logger log;
    private ConverterManager converterManager = null;
    private CreatorManager creatorManager = null;
    private AccessControl accessControl = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.impl.ExecuteQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public ExecuteQuery(CreatorManager creatorManager, ConverterManager converterManager, AccessControl accessControl) {
        this.creatorManager = creatorManager;
        this.converterManager = converterManager;
        this.accessControl = accessControl;
    }

    public Calls execute(HttpServletRequest req) throws IOException {
        Calls calls = null;
        calls = req.getMethod().equals("GET") ? this.parseParameters(this.parseGet(req)) : this.parseParameters(this.parsePost(req));
        OutboundContext converted = new OutboundContext();
        int callNum = 0;
        while (callNum < calls.getCallCount()) {
            Call call = calls.getCall(callNum);
            InboundContext inctx = call.getInboundContext();
            try {
                Creator creator = this.creatorManager.getCreator(call.getScriptName());
                Method method = this.findMethod(call);
                if (method == null) {
                    String name = String.valueOf(call.getScriptName()) + '.' + call.getMethodName();
                    throw new IllegalArgumentException(Messages.getString("ExecuteQuery.UnknownMethod", name));
                }
                String reason = this.accessControl.getReasonToNotExecute(req, creator, call.getScriptName(), method);
                if (reason != null) {
                    log.error("Access denied: " + reason);
                    log.error("  From: " + req.getRemoteAddr() + " asking for: " + req.getRequestURI());
                    throw new SecurityException(Messages.getString("ExecuteQuery.AccessDenied"));
                }
                Object[] params = new Object[method.getParameterTypes().length];
                int j = 0;
                while (j < method.getParameterTypes().length) {
                    Class<?> paramType = method.getParameterTypes()[j];
                    InboundVariable param = inctx.getParameter(callNum, j);
                    inctx.pushContext(method, j);
                    params[j] = this.converterManager.convertInbound(paramType, param, inctx);
                    inctx.popContext(method, j);
                    ++j;
                }
                Object object = null;
                if (!Modifier.isStatic(method.getModifiers())) {
                    String scope = creator.getScope();
                    ExecutionContext execCtx = ExecutionContext.get();
                    if (scope.equals("application")) {
                        object = execCtx.getServletContext().getAttribute(call.getScriptName());
                    } else if (scope.equals("session")) {
                        object = execCtx.getSession().getAttribute(call.getScriptName());
                    } else if (scope.equals("request")) {
                        object = execCtx.getHttpServletRequest().getAttribute(call.getScriptName());
                    }
                    if (object == null) {
                        log.debug("Create Object: script=" + call.getScriptName() + ", scope=" + scope + ", creator=" + creator.getClass().getName());
                        object = creator.getInstance();
                    } else {
                        log.debug("Fetched Object: script=" + call.getScriptName() + ", scope=" + scope + ", creator=" + creator.getClass().getName());
                    }
                    if (scope.equals("application")) {
                        execCtx.getServletContext().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("session")) {
                        execCtx.getSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("request")) {
                        execCtx.getHttpServletRequest().setAttribute(call.getScriptName(), object);
                    }
                }
                log.info("Executing: " + method.toString());
                Object reply = method.invoke(object, params);
                OutboundVariable ov = this.converterManager.convertOutbound(reply, converted);
                call.setReply(ov);
            }
            catch (InvocationTargetException ex) {
                log.warn("Method execution failed: ", ex.getTargetException());
                call.setThrowable(ex.getTargetException());
            }
            catch (Throwable ex) {
                log.warn("Method execution failed: ", ex);
                call.setThrowable(ex);
            }
            ++callNum;
        }
        return calls;
    }

    private Map parsePost(HttpServletRequest req) throws IOException {
        String line;
        HashMap paramMap = new HashMap();
        BufferedReader in = req.getReader();
        if (in == null) {
            throw new RuntimeException(Messages.getString("ExecuteQuery.ErrorNullPost"));
        }
        while ((line = in.readLine()) != null) {
            if (line.indexOf(38) == -1) {
                log.debug("POST line: " + line);
                this.parsePostLine(line, paramMap);
                continue;
            }
            StringTokenizer st = new StringTokenizer(line, "&");
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                part = LocalUtil.decode(part);
                log.debug("iframe POST line: " + part);
                this.parsePostLine(part, paramMap);
            }
        }
        return paramMap;
    }

    private void parsePostLine(String line, Map paramMap) {
        if (line.length() == 0) {
            return;
        }
        int sep = line.indexOf("=");
        if (sep == -1) {
            log.warn("Missing separator in POST line: " + line);
        } else {
            String key = line.substring(0, sep);
            String value = line.substring(sep + "=".length());
            paramMap.put(key, value);
        }
    }

    private Map parseGet(HttpServletRequest req) throws IOException {
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        Map paramMap = req.getParameterMap();
        Iterator it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] array = (String[])paramMap.get(key);
            if (array.length == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("GET line: " + key + '=' + array[0]);
                }
                convertedMap.put(key, array[0]);
                continue;
            }
            throw new IOException(Messages.getString("ExecuteQuery.MultiValues", key));
        }
        return convertedMap;
    }

    private Calls parseParameters(Map paramMap) {
        Call call;
        Calls calls = new Calls();
        calls.setXhrMode(Boolean.valueOf((String)paramMap.remove("xml")));
        String callStr = (String)paramMap.remove("callCount");
        int callCount = Integer.parseInt(callStr);
        int callNum = 0;
        while (callNum < callCount) {
            call = new Call();
            calls.addCall(call);
            String prefix = "c" + callNum + "-";
            call.setId((String)paramMap.remove(String.valueOf(prefix) + "id"));
            call.setScriptName((String)paramMap.remove(String.valueOf(prefix) + "scriptName"));
            call.setMethodName((String)paramMap.remove(String.valueOf(prefix) + "methodName"));
            Iterator it = paramMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                String data = (String)entry.getValue();
                String[] split = LocalUtil.splitInbound(data);
                String value = split[1];
                String type = split[0];
                call.getInboundContext().createInboundVariable(callNum, key, type, value);
                it.remove();
            }
            ++callNum;
        }
        if (paramMap.size() != 0) {
            log.warn("Entries left over in parameter map");
        }
        if (log.isDebugEnabled()) {
            callNum = 0;
            while (callNum < calls.getCallCount()) {
                call = calls.getCall(callNum);
                log.debug("Call[" + callNum + "]: " + call.getScriptName() + '.' + call.getMethodName() + "();");
                int i = 0;
                while (i < call.getInboundContext().getParameterCount()) {
                    log.debug("  Param: " + i + '=' + call.getInboundContext().getParameter(callNum, i));
                    ++i;
                }
                ++callNum;
            }
            if (calls.getCallCount() > 0) {
                InboundContext inctx = calls.getCall(0).getInboundContext();
                Iterator it = inctx.getInboundVariableNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    InboundVariable value = inctx.getInboundVariable(key);
                    log.debug("  Env: " + key + '=' + value.getRawData());
                }
            }
        }
        return calls;
    }

    private Method findMethod(Call call) {
        if (call.getScriptName() == null) {
            throw new IllegalArgumentException(Messages.getString("ExecuteQuery.MissingClassParam"));
        }
        if (call.getMethodName() == null) {
            throw new IllegalArgumentException(Messages.getString("ExecuteQuery.MissingMethodParam"));
        }
        Creator creator = this.creatorManager.getCreator(call.getScriptName());
        Method[] methods = creator.getType().getMethods();
        ArrayList<Method> available = new ArrayList<Method>();
        int i = 0;
        block0: while (i < methods.length) {
            if (methods[i].getName().equals(call.getMethodName()) && methods[i].getParameterTypes().length == call.getInboundContext().getParameterCount()) {
                call.getInboundContext().clearConverted();
                int j = 0;
                while (j < methods[i].getParameterTypes().length) {
                    Class<?> paramType = methods[i].getParameterTypes()[j];
                    if (!this.converterManager.isConvertable(paramType)) break block0;
                    ++j;
                }
                available.add(methods[i]);
            }
            ++i;
        }
        if (available.size() > 1) {
            log.warn("Warning multiple matching methods. Using first match.");
        }
        if (available.isEmpty()) {
            return null;
        }
        return (Method)available.get(0);
    }
}

