/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class CollectionConverter
implements Converter {
    private ConverterManager config = null;
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.convert.CollectionConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("[")) {
            throw new IllegalArgumentException(Messages.getString("CollectionConverter.MissingOpener", "["));
        }
        if (!value.endsWith("]")) {
            throw new IllegalArgumentException(Messages.getString("CollectionConverter.MissingCloser", "]"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Method method = inctx.getCurrentMethod();
            int paramNum = inctx.getCurrentParameterNum();
            Class subtype = this.config.getExtraTypeInfo(method, paramNum, 0);
            if (subtype == null) {
                log.warn("Missing type info for " + method.getName() + "(), param=" + paramNum + ". Assuming this is a collection of Strings. Please add to <signatures> in dwr.xml");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                subtype = clazz;
            } else {
                log.debug("Using extra type info for " + method.getName() + "(), param=" + paramNum + " of " + subtype);
            }
            Collection<Object> col = null;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.util.Iterator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (!paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers())) {
                col = (Collection)paramType.newInstance();
            } else {
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.util.Set");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.isAssignableFrom(paramType)) {
                    col = new HashSet();
                } else {
                    Class<?> clazz3 = class$4;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$4 = Class.forName("java.util.List");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz3.isAssignableFrom(paramType)) {
                        col = new ArrayList();
                    } else {
                        Class<?> clazz4 = class$5;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$5 = Class.forName("java.util.Collection");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz4.isAssignableFrom(paramType)) {
                            col = new ArrayList();
                        } else {
                            throw new ConversionException(String.valueOf(Messages.getString("CollectionConverter.ConvertError")) + paramType.getName());
                        }
                    }
                }
            }
            inctx.addConverted(iv, col);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            int i = 0;
            while (i < size) {
                String token = st.nextToken();
                String[] split = LocalUtil.splitInbound(token);
                InboundVariable nested = new InboundVariable(iv.getLookup(), split[0], split[1]);
                Object output = this.config.convertInbound(subtype, nested, inctx);
                col.add(output);
                ++i;
            }
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("java.util.Iterator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz5.isAssignableFrom(paramType)) {
                return col.iterator();
            }
            return col;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        Iterator it = null;
        if (data instanceof Collection) {
            Collection col = (Collection)data;
            it = col.iterator();
        } else if (data instanceof Iterator) {
            it = (Iterator)data;
        } else {
            throw new ConversionException(Messages.getString("CollectionConverter.ConvertFailed", data.getClass().getName()));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("var " + varname + " = new Array();");
        int i = 0;
        while (it.hasNext()) {
            Object element = it.next();
            OutboundVariable nested = this.config.convertOutbound(element, outctx);
            buffer.append(nested.getInitCode());
            buffer.append(varname);
            buffer.append('[');
            buffer.append(i);
            buffer.append("] = ");
            buffer.append(nested.getAssignCode());
            buffer.append(';');
            ++i;
        }
        return buffer.toString();
    }
}

